/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.SpanContext;
import io.opentracing.mock.MockSpan;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

class ProxyMockSpanContext
extends MockSpan.MockContext {
    final SpanContext mockSpanContext;
    final SpanContext realSpanContext;

    ProxyMockSpanContext(MockSpan.MockContext mockSpanContext, SpanContext realSpanContext) {
        super(-1L, -1L, null);
        this.mockSpanContext = Objects.requireNonNull(mockSpanContext);
        this.realSpanContext = Objects.requireNonNull(realSpanContext);
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        Iterable mockBaggageItems = this.mockSpanContext.baggageItems();
        Iterable realBaggageItems = this.realSpanContext.baggageItems();
        if (mockBaggageItems != null ? realBaggageItems == null : realBaggageItems != null) {
            throw new IllegalStateException();
        }
        return mockBaggageItems == null ? null : new ProxyIterator(mockBaggageItems.iterator(), realBaggageItems.iterator());
    }

    private class ProxyIterator
    implements Iterable<Map.Entry<String, String>>,
    Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<String, String>> mockIterator;
        private final Iterator<Map.Entry<String, String>> realIterator;

        private ProxyIterator(Iterator<Map.Entry<String, String>> mockIterator, Iterator<Map.Entry<String, String>> realIterator) {
            this.mockIterator = Objects.requireNonNull(mockIterator);
            this.realIterator = Objects.requireNonNull(realIterator);
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            boolean realHasNext;
            boolean mockHasNext = this.mockIterator.hasNext();
            if (mockHasNext != (realHasNext = this.realIterator.hasNext())) {
                throw new IllegalStateException();
            }
            return mockHasNext;
        }

        @Override
        public Map.Entry<String, String> next() {
            Map.Entry<String, String> mockNext = this.mockIterator.next();
            Map.Entry<String, String> realNext = this.realIterator.next();
            return new ProxyEntry(mockNext, realNext);
        }

        @Override
        public void remove() {
            this.mockIterator.remove();
            this.realIterator.remove();
        }

        private class ProxyEntry
        implements Map.Entry<String, String> {
            private final Map.Entry<String, String> mockEntry;
            private final Map.Entry<String, String> realEntry;

            private ProxyEntry(Map.Entry<String, String> mockEntry, Map.Entry<String, String> realEntry) {
                if (mockEntry != null ? realEntry == null || !mockEntry.getKey().equals(realEntry.getKey()) || !mockEntry.getValue().equals(realEntry.getValue()) : realEntry != null) {
                    throw new IllegalStateException();
                }
                this.mockEntry = mockEntry;
                this.realEntry = realEntry;
            }

            @Override
            public String getKey() {
                return this.mockEntry.getKey();
            }

            @Override
            public String getValue() {
                return this.mockEntry.getValue();
            }

            @Override
            public String setValue(String value) {
                String mockValue = this.mockEntry.setValue(value);
                String realValue = this.realEntry.setValue(value);
                if (mockValue != null ? !mockValue.equals(realValue) : realValue != null) {
                    throw new IllegalStateException();
                }
                return mockValue;
            }
        }
    }
}

