/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.BootProxyClassLoader;
import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;

public final class AgentRuleUtil {
    public static String getNameId(Object obj) {
        return obj != null ? obj.getClass().getName() + "@" + Integer.toString(System.identityHashCode(obj), 16) : "null";
    }

    public static String getSimpleNameId(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() + "@" + Integer.toString(System.identityHashCode(obj), 16) : "null";
    }

    public static <T> T[] subArray(T[] array, int beginIndex, int endIndex) {
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex (" + endIndex + ") < beginIndex (" + beginIndex + ")");
        }
        Class<?> componentType = array.getClass().getComponentType();
        Object[] subArray = (Object[])Array.newInstance(componentType, endIndex - beginIndex);
        if (beginIndex == endIndex) {
            return subArray;
        }
        System.arraycopy(array, beginIndex, subArray, 0, endIndex - beginIndex);
        return subArray;
    }

    public static <T> T[] subArray(T[] array, int beginIndex) {
        return AgentRuleUtil.subArray(array, beginIndex, array.length);
    }

    public static Class<?>[] getExecutionStack() {
        return AgentRuleUtil.subArray(new CallingClass().getClassContext(), 3);
    }

    public static StackTraceElement[] getCallStack() {
        return AgentRuleUtil.subArray(Thread.currentThread().getStackTrace(), 2);
    }

    public static boolean callerEquals(int frameIndex, String name) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length <= (frameIndex += 2)) {
            return false;
        }
        StackTraceElement stackTraceElement = stackTraceElements[frameIndex];
        String element = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        return element.equals(name);
    }

    public static boolean callerEquals(int startFrame, int endFrame, String name) {
        endFrame += 2;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length <= (startFrame += 2)) {
            return false;
        }
        if (stackTraceElements.length < endFrame) {
            endFrame = stackTraceElements.length;
        }
        for (int i = startFrame; i < endFrame; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            String element = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            if (!element.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean callerEquals(int frameIndex, String ... names) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length <= (frameIndex += 2)) {
            return false;
        }
        StackTraceElement stackTraceElement = stackTraceElements[frameIndex];
        String element = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        for (int i = 0; i < names.length; ++i) {
            if (!element.equals(names[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean callerEquals(int startFrame, int endFrame, String ... names) {
        endFrame += 2;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length <= (startFrame += 2)) {
            return false;
        }
        if (stackTraceElements.length < endFrame) {
            endFrame = stackTraceElements.length;
        }
        for (int i = startFrame; i < endFrame; ++i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            String element = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            for (int j = 0; j < names.length; ++j) {
                if (!element.equals(names[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMethodNamed(TypeDefinition typeDefinition, String methodName) {
        do {
            for (Object method : typeDefinition.getDeclaredMethods()) {
                if (!methodName.equals(((MethodDescription.AbstractBase)method).getActualName())) continue;
                return true;
            }
        } while (typeDefinition.getSuperClass() != null && !"java.lang.Object".equals((typeDefinition = typeDefinition.getSuperClass()).getActualName()));
        return false;
    }

    public static <T> T getFieldInBootstrapClass(Class<?> cls, String fieldName) {
        try {
            return (T)BootProxyClassLoader.INSTANCE.loadClass(cls.getName()).getField(fieldName).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static boolean isFromClassLoader(Class<?>[] callStack, ClassLoader classLoader) {
        block0: for (Class<?> cls : callStack) {
            ClassLoader parent = cls.getClassLoader();
            while (parent != classLoader) {
                if (parent == null) continue block0;
                parent = parent.getParent();
            }
            return true;
        }
        return false;
    }

    public static URL[] classPathToURLs(String classpath) {
        if (classpath == null) {
            return null;
        }
        try {
            String[] paths = classpath.split(File.pathSeparator);
            URL[] files = new URL[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                files[i] = new URL("file", "", paths[i].endsWith(".jar") || paths[i].endsWith("/") ? paths[i] : paths[i] + "/");
            }
            return files;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    private AgentRuleUtil() {
    }

    private static class CallingClass
    extends SecurityManager {
        private CallingClass() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

