/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.BootLoaderAgent;
import io.opentracing.contrib.specialagent.BootProxyClassLoader;
import io.opentracing.contrib.specialagent.SpecialAgentUtil;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.jar.JarFile;
import net.bytebuddy.agent.ByteBuddyAgent;

public final class AgentRunnerBootstrap {
    private static Instrumentation inst;

    private static JarFile createJarFileOfSource(Class<?> cls) throws IOException {
        return AgentRunnerBootstrap.createJarFileOfSource(new File(cls.getProtectionDomain().getCodeSource().getLocation().getPath()));
    }

    private static JarFile createJarFileOfSource(File file) throws IOException {
        String path = file.getAbsolutePath();
        if (file.isDirectory()) {
            if ("classes".equals(file.getName())) {
                return SpecialAgentUtil.createTempJarFile(file);
            }
            if ("test-classes".equals(file.getName())) {
                return SpecialAgentUtil.createTempJarFile(new File(file.getParent(), "classes"));
            }
        } else {
            if (path.endsWith(".jar")) {
                return new JarFile(file);
            }
            if (path.endsWith("-tests.jar")) {
                return new JarFile(new File(path.substring(0, path.length() - 10) + ".jar"));
            }
        }
        throw new UnsupportedOperationException("Unsupported source path: " + path);
    }

    private static JarFile[] appendSourceLocationToBootstrap(Class<?> cls) throws IOException {
        return new JarFile[]{AgentRunnerBootstrap.createJarFileOfSource(cls)};
    }

    private static JarFile[] appendSourceLocationToBootstrap(File ... files) throws IOException {
        JarFile[] jarFiles = new JarFile[files.length + 1];
        jarFiles[0] = AgentRunnerBootstrap.createJarFileOfSource(AgentRunnerBootstrap.class);
        for (int i = 0; i < files.length; ++i) {
            jarFiles[i + 1] = AgentRunnerBootstrap.createJarFileOfSource(files[i]);
        }
        return jarFiles;
    }

    static Instrumentation install(File[] bootstrapFiles) {
        if (inst != null) {
            return inst;
        }
        try {
            JarFile[] jarFiles = bootstrapFiles != null ? AgentRunnerBootstrap.appendSourceLocationToBootstrap(bootstrapFiles) : AgentRunnerBootstrap.appendSourceLocationToBootstrap(AgentRunnerBootstrap.class);
            Instrumentation inst = ByteBuddyAgent.install();
            for (JarFile jarFile : jarFiles) {
                inst.appendToBootstrapClassLoaderSearch(jarFile);
            }
            BootLoaderAgent.premain(inst, jarFiles);
            if (BootProxyClassLoader.INSTANCE.loadClassOrNull("io.opentracing.contrib.specialagent.Level", false) == null) {
                throw new IllegalStateException();
            }
            if (BootProxyClassLoader.INSTANCE.getResource("io/opentracing/contrib/specialagent/Adapter.class") == null) {
                throw new IllegalStateException();
            }
            AgentRunnerBootstrap.inst = inst;
            return AgentRunnerBootstrap.inst;
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private AgentRunnerBootstrap() {
    }
}

