/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.BiConsumer;
import io.opentracing.contrib.specialagent.Function;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.Predicate;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class AssembleUtil {
    private static final Logger logger = Logger.getLogger(AssembleUtil.class);
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 65536;
    private static boolean propertiesLoaded = false;

    public static boolean hasFileInJar(File jarFile, String name) throws IOException {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            boolean bl = AssembleUtil.getEntryFromJar(zipFile, name) != null;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public static String readFileFromJar(File jarFile, String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ZipEntry getEntryFromJar(ZipFile zipFile, String name) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static Set<String> getLocations(Class<?> ... classes) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (Class<?> cls : classes) {
            String resourceName = AssembleUtil.classNameToResource(cls);
            Enumeration<URL> resources = classLoader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                String resource = resources.nextElement().getFile();
                locations.add(resource.startsWith("file:") ? resource.substring(5, resource.indexOf(33)) : resource.substring(0, resource.length() - resourceName.length() - 1));
            }
        }
        return locations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(URL url) {
        try (InputStream in = url.openStream();){
            byte[] byArray = AssembleUtil.readBytes(in);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        byte[] bytes = new byte[65536];
        while ((len = in.read(bytes)) != -1) {
            if (len == 0) continue;
            buffer.write(bytes, 0, len);
        }
        return buffer.toByteArray();
    }

    public static String toIndentedString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                builder.append(",\n");
            }
            builder.append(a[i]);
        }
        return builder.toString();
    }

    public static String toIndentedString(Collection<?> l) {
        if (l == null) {
            return "null";
        }
        if (l.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator = l.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i > 0) {
                builder.append(",\n");
            }
            builder.append(iterator.next());
            ++i;
        }
        return builder.toString();
    }

    public static String toIndentedString(Map<?, ?> m) {
        if (m == null) {
            return "null";
        }
        if (m.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<?, ?>> iterator = m.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i > 0) {
                builder.append(",\n");
            }
            builder.append(iterator.next());
            ++i;
        }
        return builder.toString();
    }

    public static boolean recurseDir(File dir, Predicate<File> predicate) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (AssembleUtil.recurseDir(file, predicate)) continue;
                return false;
            }
        }
        return predicate.test(dir);
    }

    public static FileVisitResult recurseDir(File dir, Function<File, FileVisitResult> function) {
        File[] files = dir.listFiles();
        if (files != null) {
            File file;
            FileVisitResult result;
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n && (result = AssembleUtil.recurseDir(file = fileArray[i], function)) != FileVisitResult.SKIP_SIBLINGS; ++i) {
                if (result == FileVisitResult.TERMINATE) {
                    return result;
                }
                if (result != FileVisitResult.SKIP_SUBTREE) continue;
                return FileVisitResult.SKIP_SIBLINGS;
            }
        }
        return function.apply(dir);
    }

    public static <T extends Comparable<? super T>> int compare(T[] a, T[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.length, b.length);
        for (int i = 0; i < length; ++i) {
            T oa = a[i];
            T ob = b[i];
            if (oa == ob) continue;
            if (oa == null || ob == null) {
                return oa == null ? -1 : 1;
            }
            int v = oa.compareTo(ob);
            if (v == 0) continue;
            return v;
        }
        return a.length - b.length;
    }

    public static <T extends Comparable<? super T>> int compare(List<T> a, List<T> b) {
        if (a == b) {
            return 0;
        }
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int length = Math.min(a.size(), b.size());
        for (int i = 0; i < length; ++i) {
            Comparable ob;
            Comparable oa = (Comparable)a.get(i);
            if (oa == (ob = (Comparable)b.get(i))) continue;
            if (oa == null || ob == null) {
                return oa == null ? -1 : 1;
            }
            int v = oa.compareTo(ob);
            if (v == 0) continue;
            return v;
        }
        return a.size() - b.size();
    }

    public static <T extends Comparable<? super T>> boolean containsAll(T[] a, T[] b) {
        int i = 0;
        int j = 0;
        while (j != b.length) {
            if (i == a.length) {
                return false;
            }
            int comparison = a[i].compareTo(b[j]);
            if (comparison > 0) {
                return false;
            }
            ++i;
            if (comparison != 0) continue;
            ++j;
        }
        return true;
    }

    public static <T> boolean containsAll(T[] a, T[] b, Comparator<T> c) {
        int i = 0;
        int j = 0;
        while (j != b.length) {
            if (i == a.length) {
                return false;
            }
            int comparison = c.compare(a[i], b[j]);
            if (comparison > 0) {
                return false;
            }
            ++i;
            if (comparison != 0) continue;
            ++j;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> T[] retain(T[] a, T[] b, int i, int j, int r) {
        int d = 0;
        while (true) {
            int comparison = 0;
            if (i + d == a.length || j + d == b.length || (comparison = a[i + d].compareTo(b[j + d])) != 0) {
                Comparable[] retained = i + d == a.length || j + d == b.length ? (r + d == 0 ? null : (Comparable[])Array.newInstance(a.getClass().getComponentType(), r + d)) : (comparison < 0 ? AssembleUtil.retain(a, b, (int)(i + d + 1), (int)(j + d), (int)(r + d)) : AssembleUtil.retain(a, b, (int)(i + d), (int)(j + d + 1), (int)(r + d)));
                if (d > 0) {
                    System.arraycopy(a, i, retained, r, d);
                }
                return retained;
            }
            ++d;
        }
    }

    public static <T> T[] sort(T[] array) {
        if (array == null) {
            return null;
        }
        Arrays.sort(array);
        return array;
    }

    public static <T extends Comparable<? super T>> List<T> sort(List<T> list) {
        if (list == null) {
            return null;
        }
        Collections.sort(list);
        return list;
    }

    public static String getNameId(Object obj) {
        return obj != null ? obj.getClass().getName() + "@" + Integer.toString(System.identityHashCode(obj), 16) : "null";
    }

    public static String getSimpleNameId(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() + "@" + Integer.toString(System.identityHashCode(obj), 16) : "null";
    }

    public static String toString(Object[] a, String del) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                builder.append(del);
            }
            builder.append(String.valueOf(a[i]));
        }
        return builder.toString();
    }

    public static String toString(Collection<?> c, String del) {
        if (c == null) {
            return "null";
        }
        if (c.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator = c.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i > 0) {
                builder.append(del);
            }
            builder.append(String.valueOf(iterator.next()));
            ++i;
        }
        return builder.toString();
    }

    public static void absorbProperties(String command) {
        String[] parts = command.split("\\s+-");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.charAt(0) != 'D') continue;
            int index = part.indexOf(61);
            if (index == -1) {
                System.setProperty(part.substring(1), "");
                continue;
            }
            System.setProperty(part.substring(1, index), part.substring(index + 1));
        }
    }

    public static <T> void forEachClass(URL[] urls, final T arg, final BiConsumer<String, T> consumer) throws IOException {
        for (URL url : urls) {
            if (url.getPath().endsWith(".jar")) {
                try (ZipInputStream in = new ZipInputStream(url.openStream());){
                    ZipEntry entry;
                    while ((entry = in.getNextEntry()) != null) {
                        String name = entry.getName();
                        if (!name.endsWith(".class") || name.startsWith("META-INF/") || name.startsWith("module-info")) continue;
                        consumer.accept(name, (String)arg);
                    }
                    continue;
                }
            }
            File file = new File(url.getPath());
            final Path path = file.toPath();
            AssembleUtil.recurseDir(file, new Predicate<File>(){

                @Override
                public boolean test(File t) {
                    if (t.isDirectory()) {
                        return true;
                    }
                    String name = path.relativize(t.toPath()).toString();
                    if (name.endsWith(".class") && !name.startsWith("META-INF/") && !name.startsWith("module-info")) {
                        consumer.accept(name, arg);
                    }
                    return true;
                }
            });
        }
    }

    private static URL _toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        return new URL("file", "", file.isDirectory() ? path + "/" : path);
    }

    public static URL toURL(File file) {
        try {
            return AssembleUtil._toURL(file);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL[] toURLs(File ... files) {
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = AssembleUtil._toURL(files[i]);
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL[] toURLs(List<File> files) {
        try {
            URL[] urls = new URL[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                urls[i] = AssembleUtil._toURL(files.get(i));
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL[] toURLs(Collection<File> files) {
        try {
            URL[] urls = new URL[files.size()];
            Iterator<File> iterator = files.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                urls[i] = AssembleUtil._toURL(iterator.next());
                ++i;
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String convertToRegex(String pattern) {
        return pattern.replace("\\", "\\\\").replace(".", "\\.").replace("^", "\\^").replace("$", "\\$").replace("*", ".*").replace("/", "\\/").replace('?', '.');
    }

    public static String classNameToResource(String className) {
        return className.replace('.', '/').concat(".class");
    }

    public static String classNameToResource(Class<?> cls) {
        return AssembleUtil.classNameToResource(cls.getName());
    }

    public static String resourceToClassName(String resource) {
        return resource.substring(0, resource.length() - 6).replace('/', '.');
    }

    public static boolean isSystemProperty(String key, String deprecatedKey) {
        String value = System.getProperty(key);
        if (value != null) {
            return !"false".equals(value);
        }
        if (deprecatedKey == null) {
            return false;
        }
        value = System.getProperty(deprecatedKey);
        if (value == null) {
            return false;
        }
        logger.warning("Deprecated key (as of v1.7.0): \"" + deprecatedKey + "\" should be changed to \"" + key + "\"");
        return !"false".equals(value);
    }

    public static Pattern convertToNameRegex(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("Empty pattern");
        }
        char lastCh = pattern.charAt(pattern.length() - 1);
        if (lastCh == '*') {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        String regex = "^" + AssembleUtil.convertToRegex(pattern).replace(".*", "[^:]*");
        boolean hasDigit = false;
        for (int i = regex.length() - 2; i >= 0; --i) {
            if (regex.charAt(i) != ':') continue;
            hasDigit = Character.isDigit(regex.charAt(i + 1));
            break;
        }
        if (lastCh == '?') {
            return Pattern.compile(regex);
        }
        if (hasDigit || regex.length() == 1 || regex.endsWith(":")) {
            return Pattern.compile(regex + ".*");
        }
        return Pattern.compile("(" + regex + "$|" + regex + ":.*)");
    }

    public static File getSourceLocation(URL url, String resourcePath) throws MalformedURLException {
        String string = url.toString();
        if (!string.endsWith(resourcePath)) {
            throw new IllegalArgumentException(url + " does not end with \"" + resourcePath + "\"");
        }
        if (string.startsWith("jar:file:")) {
            return new File(string.substring(9, string.lastIndexOf(33)));
        }
        if (string.startsWith("file:")) {
            return new File(string.substring(5, string.length() - resourcePath.length()));
        }
        throw new UnsupportedOperationException("Unsupported protocol: " + url.getProtocol());
    }

    public static String getName(String path) {
        int start;
        if (path.length() == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (path.length() == 0) {
            return path;
        }
        boolean end = path.charAt(path.length() - 1) == File.separatorChar;
        int n = start = end ? path.lastIndexOf(File.separatorChar, path.length() - 2) : path.lastIndexOf(File.separatorChar);
        return start == -1 ? (end ? path.substring(0, path.length() - 1) : path) : (end ? path.substring(start + 1, path.length() - 1) : path.substring(start + 1));
    }

    private static void loadProperties(Map<String, String> properties, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            char ch;
            if ((line = line.trim()).length() == 0 || (ch = line.charAt(0)) == '#' || ch == '!') continue;
            int eq = line.indexOf(61);
            if (eq == -1) {
                properties.put(line, "");
                continue;
            }
            if (eq <= 0) continue;
            String key = line.substring(0, eq).trim();
            String value = line.substring(eq + 1).trim();
            if (key.length() <= 0) continue;
            properties.put(key, value);
        }
    }

    static void loadProperties() {
        if (propertiesLoaded) {
            return;
        }
        propertiesLoaded = true;
        String configProperty = System.getProperty("sa.config");
        try (InputStream defaultConfig = Thread.currentThread().getContextClassLoader().getResourceAsStream("default.properties");
             FileReader userConfig = configProperty == null ? null : new FileReader(configProperty);){
            HashMap<String, String> properties = new HashMap<String, String>();
            AssembleUtil.loadProperties(properties, new BufferedReader(new InputStreamReader(defaultConfig)));
            if (userConfig != null) {
                AssembleUtil.loadProperties(properties, new BufferedReader(userConfig));
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (System.getProperty((String)entry.getKey()) != null) continue;
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Logger.refreshLoggers();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File[] classPathToFiles(String classpath) {
        if (classpath == null) {
            return null;
        }
        String[] paths = classpath.split(File.pathSeparator);
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]).getAbsoluteFile();
        }
        return files;
    }

    public static URL toURL(String path) {
        try {
            return new URL("file", "", path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private AssembleUtil() {
    }
}

