/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.CachedClassFileLocator;
import io.opentracing.contrib.specialagent.ClassLoaderAgent;
import io.opentracing.contrib.specialagent.CompoundEnumeration;
import io.opentracing.contrib.specialagent.DefaultAgentRule;
import io.opentracing.contrib.specialagent.SpecialAgentAgent;
import io.opentracing.contrib.specialagent.SpecialAgentUtil;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class BootLoaderAgent {
    public static final CachedClassFileLocator cachedLocator;
    public static JarFile[] jarFiles;
    private static boolean loaded;

    private static boolean hasClassMethod(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(className);
            return BootLoaderAgent.hasMethod(cls, methodName, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean hasMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            cls.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static void premain(Instrumentation inst, JarFile[] jarFiles) {
        if (loaded) {
            return;
        }
        BootLoaderAgent.jarFiles = jarFiles == null || jarFiles.length == 0 ? null : jarFiles;
        AgentBuilder builder = new AgentBuilder.Default().ignore(ElementMatchers.nameStartsWith("net.bytebuddy.").or(ElementMatchers.nameStartsWith("sun.reflect.")).or(ElementMatchers.isSynthetic()), ElementMatchers.any(), ElementMatchers.any()).disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.TypeStrategy.Default.REDEFINE);
        builder = builder.type(ElementMatchers.isSubTypeOf(Instrumentation.class)).transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit(Advice.to(AppendToBootstrap.class, (ClassFileLocator)cachedLocator).on(ElementMatchers.named("appendToBootstrapClassLoaderSearch").and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, JarFile.class)))));
            }
        });
        if (BootLoaderAgent.hasMethod(ClassLoader.class, "getBootstrapResource", String.class)) {
            builder = builder.type(ElementMatchers.isSubTypeOf(ClassLoader.class)).transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit(Advice.to(FindBootstrapResource.class, (ClassFileLocator)cachedLocator).on(ElementMatchers.isStatic().and(ElementMatchers.named("getBootstrapResource").and(ElementMatchers.returns(URL.class).and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, String.class)))))));
                }
            }).transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit(Advice.to(FindBootstrapResources.class, (ClassFileLocator)cachedLocator).on(ElementMatchers.isStatic().and(ElementMatchers.named("getBootstrapResources").and(ElementMatchers.returns(Enumeration.class).and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, String.class)))))));
                }
            });
        }
        if (BootLoaderAgent.hasClassMethod("jdk.internal.loader.BuiltinClassLoader", "findResource", String.class)) {
            builder = builder.type(ElementMatchers.hasSuperType(ElementMatchers.named("jdk.internal.loader.BuiltinClassLoader"))).transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit(Advice.to(FindBootstrapResource.class, (ClassFileLocator)cachedLocator).on(ElementMatchers.named("findResource").and(ElementMatchers.returns(URL.class).and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, String.class))))));
                }
            }).transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit(Advice.to(FindBootstrapResources.class, (ClassFileLocator)cachedLocator).on(ElementMatchers.named("findResources").and(ElementMatchers.returns(Enumeration.class).and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, String.class))))));
                }
            });
        }
        builder.installOn(inst);
        loaded = true;
    }

    static {
        loaded = false;
        try {
            cachedLocator = new CachedClassFileLocator(ClassFileLocator.ForClassLoader.ofSystemLoader(), FindBootstrapResource.class, FindBootstrapResources.class, AppendToBootstrap.class, ClassLoaderAgent.DefineClass.class, ClassLoaderAgent.LoadClass.class, ClassLoaderAgent.FindResource.class, ClassLoaderAgent.FindResources.class, SpecialAgentAgent.FindClass.class, SpecialAgentAgent.FindResource.class, SpecialAgentAgent.FindResources.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class AppendToBootstrap {
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) JarFile arg) {
            try {
                if (jarFiles == null) {
                    jarFiles = new JarFile[]{arg};
                } else {
                    int len = jarFiles.length;
                    JarFile[] temp = new JarFile[len + 1];
                    System.arraycopy(jarFiles, 0, temp, 0, len);
                    temp[len] = arg;
                    jarFiles = temp;
                }
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> BootLoaderAgent.AppendToBootstrap#exit", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
        }
    }

    public static class FindBootstrapResources {
        public static final Mutex mutex = new Mutex();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) String name, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Enumeration<URL> returned) {
            if (jarFiles == null) {
                return;
            }
            Set visited = (Set)mutex.get();
            if (!visited.add(name)) {
                return;
            }
            try {
                URL[] resources = FindBootstrapResources.findResources(name, jarFiles, 0, 0);
                if (resources != null) {
                    CompoundEnumeration enumeration = SpecialAgentUtil.enumeration(resources);
                    returned = returned == null ? enumeration : new CompoundEnumeration(returned, enumeration);
                }
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> BootLoaderAgent.FindBootstrapResources#exit", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
            finally {
                visited.remove(name);
            }
        }

        public static URL[] findResources(String name, JarFile[] jarFiles, int index, int depth) throws MalformedURLException {
            if (index == jarFiles.length) {
                return depth == 0 ? null : new URL[depth];
            }
            JarEntry entry = jarFiles[index].getJarEntry(name);
            if (entry == null) {
                return FindBootstrapResources.findResources(name, jarFiles, index + 1, depth);
            }
            URL[] resources = FindBootstrapResources.findResources(name, jarFiles, index + 1, depth + 1);
            resources[depth] = new URL("jar:file:" + jarFiles[index].getName() + "!/" + name);
            return resources;
        }
    }

    public static class FindBootstrapResource {
        public static final Mutex mutex = new Mutex();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) String name, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) URL returned) {
            if (returned != null || jarFiles == null) {
                return;
            }
            Set visited = (Set)mutex.get();
            if (!visited.add(name)) {
                return;
            }
            try {
                URL resource = null;
                for (JarFile jarFile : jarFiles) {
                    JarEntry entry = jarFile.getJarEntry(name);
                    if (entry == null) continue;
                    try {
                        resource = new URL("jar:file:" + jarFile.getName() + "!/" + name);
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new UnsupportedOperationException(e);
                    }
                }
                if (resource != null) {
                    returned = resource;
                }
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> BootLoaderAgent.FindBootstrapResource#exit", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
            finally {
                visited.remove(name);
            }
        }
    }

    public static class Mutex
    extends ThreadLocal<Set<String>> {
        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    }
}

