/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.Adapter;
import io.opentracing.contrib.specialagent.AgentRule;
import io.opentracing.contrib.specialagent.AgentRule$;
import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.ClassLoaderAgent;
import io.opentracing.contrib.specialagent.Event;
import io.opentracing.contrib.specialagent.IncompatiblePluginException;
import io.opentracing.contrib.specialagent.IntegrationRule;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.Manager;
import io.opentracing.contrib.specialagent.PluginManifest;
import io.opentracing.contrib.specialagent.SpecialAgent;
import io.opentracing.contrib.specialagent.TracerExclusionAgent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class ByteBuddyManager
extends Manager {
    private static final Logger logger = Logger.getLogger(ByteBuddyManager.class);
    private static final ByteBuddy byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
    private static final AgentBuilder.LocationStrategy bootFallbackLocationStrategy = new AgentBuilder.LocationStrategy(){

        @Override
        public ClassFileLocator classFileLocator(ClassLoader classLoader, JavaModule module) {
            return new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(classLoader), ClassFileLocator.ForClassLoader.ofBootLoader());
        }
    };
    private TransformationListener transformationListener;
    private final Set<String> loadedRules = new HashSet<String>();
    private boolean loadedDefaultRules;

    private AgentBuilder newBuilder(Instrumentation inst, PluginManifest pluginManifest, Event[] events) {
        AgentBuilder agentBuilder = new AgentBuilder.Default(byteBuddy);
        if (Adapter.tracerClassLoader != null) {
            agentBuilder = agentBuilder.ignore(ElementMatchers.any(), ElementMatchers.is(Adapter.tracerClassLoader));
        }
        agentBuilder = agentBuilder.ignore(ElementMatchers.nameStartsWith("net.bytebuddy.").or(ElementMatchers.nameStartsWith("sun.reflect.")).or(ElementMatchers.isSynthetic()), ElementMatchers.any(), ElementMatchers.any()).disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.TypeStrategy.Default.REDEFINE).with(bootFallbackLocationStrategy);
        if (inst == null) {
            return agentBuilder;
        }
        if (pluginManifest != null) {
            return agentBuilder.with(new TransformationListener(inst, pluginManifest, events));
        }
        if (this.transformationListener == null) {
            this.transformationListener = new TransformationListener(inst, null, events);
        }
        return agentBuilder.with(this.transformationListener);
    }

    private static void log(Level level, String message, Throwable t) {
        if (t instanceof IncompatiblePluginException || t instanceof IllegalStateException && t.getMessage().startsWith("Cannot resolve type description for ")) {
            logger.log(level, message + "\n" + t.getClass().getName() + ": " + t.getMessage());
        } else {
            logger.log(level, message, t);
        }
    }

    private static void log(Level level, String message) {
        logger.log(level, message);
    }

    ByteBuddyManager() {
        super("otarules.mf");
    }

    @Override
    int scanRules(Instrumentation inst, ClassLoader pluginsClassLoader, PluginManifest.Directory pluginManifestDirectory, List<IntegrationRule> integrationRules, Map<String, String> classNameToName) throws IOException {
        int noDeferrers = 0;
        AgentRule agentRule = null;
        try {
            Enumeration<URL> enumeration = pluginsClassLoader.getResources(this.file);
            while (enumeration.hasMoreElements()) {
                URL scriptUrl = enumeration.nextElement();
                File ruleJar = AssembleUtil.getSourceLocation(scriptUrl, this.file);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Dereferencing index for " + ruleJar);
                }
                PluginManifest pluginManifest = pluginManifestDirectory.get(ruleJar);
                ArrayList<AgentRule> deferrers = null;
                ArrayList<AgentRule> agentRules = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(scriptUrl.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                        if (this.loadedRules.contains(line)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("Skipping loaded rule: " + line);
                            continue;
                        }
                        Class<?> agentClass = pluginsClassLoader.loadClass(line);
                        if (!AgentRule.class.isAssignableFrom(agentClass)) {
                            logger.severe("Class " + agentClass.getName() + " does not implement " + AgentRule.class);
                            continue;
                        }
                        String simpleClassName = line.substring(line.lastIndexOf(46) + 1);
                        String suffix = pluginManifest.name + "#" + simpleClassName + ".disable";
                        if (AssembleUtil.isSystemProperty("sa.integration." + suffix, "sa.instrumentation.plugin." + suffix)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.fine("Skipping rule: " + line);
                            continue;
                        }
                        if (!AgentRule.class.isAssignableFrom(agentClass)) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Installing rule: " + line);
                        }
                        classNameToName.put(agentClass.getName(), pluginManifest.name);
                        agentRule = (AgentRule)agentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        AgentRule$.Access.setPluginManifest(agentRule, pluginManifest);
                        if (agentRule.isDeferrable(inst)) {
                            if (deferrers == null) {
                                deferrers = new ArrayList<AgentRule>(1);
                            }
                            ++noDeferrers;
                            deferrers.add(agentRule);
                            continue;
                        }
                        if (agentRules == null) {
                            agentRules = new ArrayList<AgentRule>(1);
                        }
                        agentRules.add(agentRule);
                    }
                }
                if (deferrers == null && agentRules == null) continue;
                integrationRules.add(new IntegrationRule(pluginManifest, deferrers, agentRules));
            }
        }
        catch (UnsupportedClassVersionError | InvocationTargetException e) {
            logger.log(Level.SEVERE, "Error initliaizing rule: " + agentRule, e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "Unable to instantiate: " + agentRule, e);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return noDeferrers;
    }

    private void loadDefaultRules(Instrumentation inst, String[] tracerExcludedClasses) {
        if (this.loadedDefaultRules) {
            return;
        }
        this.loadedDefaultRules = true;
        ClassLoaderAgent.premain(this.newBuilder(null, null, null)).installOn(inst);
        AgentBuilder builder = TracerExclusionAgent.premain(tracerExcludedClasses, this.newBuilder(null, null, null));
        if (builder != null) {
            builder.installOn(inst);
        }
    }

    @Override
    void loadRules(Instrumentation inst, boolean loadDeferrers, List<IntegrationRule> integrationRules, String[] tracerExcludedClasses, Event[] events) {
        this.loadDefaultRules(inst, tracerExcludedClasses);
        boolean hasGlobal1 = false;
        boolean hasGlobal2 = false;
        AgentBuilder chainedGlobalBuilder1 = this.newBuilder(inst, null, events);
        AgentBuilder chainedGlobalBuilder2 = this.newBuilder(inst, null, events);
        if (integrationRules != null) {
            for (IntegrationRule integrationRule : integrationRules) {
                List<AgentRule> agentRules = loadDeferrers ? integrationRule.getDeferrers() : integrationRule.getAgentRules();
                if (agentRules == null) continue;
                boolean hasLocal1 = false;
                boolean hasLocal2 = false;
                AgentBuilder chainedLocalBuilder1 = this.newBuilder(inst, null, events);
                AgentBuilder chainedLocalBuilder2 = this.newBuilder(inst, null, events);
                for (AgentRule agentRule : agentRules) {
                    this.loadedRules.add(agentRule.getClass().getName());
                    try {
                        AgentBuilder builder;
                        AgentBuilder[] unchainedBuilders = agentRule.buildAgentUnchained(this.newBuilder(inst, integrationRule.getPluginManifest(), events));
                        if (unchainedBuilders != null) {
                            for (AgentBuilder unchainedBuilder : unchainedBuilders) {
                                unchainedBuilder.installOn(inst);
                            }
                        }
                        if ((builder = agentRule.buildAgentChainedLocal1(chainedLocalBuilder1)) != null) {
                            hasLocal1 = true;
                            chainedLocalBuilder1 = builder;
                        }
                        if ((builder = agentRule.buildAgentChainedLocal2(chainedLocalBuilder2)) != null) {
                            hasLocal2 = true;
                            chainedLocalBuilder2 = builder;
                        }
                        if ((builder = agentRule.buildAgentChainedGlobal1(chainedGlobalBuilder1)) != null) {
                            hasGlobal1 = true;
                            chainedGlobalBuilder1 = builder;
                        }
                        if ((builder = agentRule.buildAgentChainedGlobal2(chainedGlobalBuilder2)) == null) continue;
                        hasGlobal2 = true;
                        chainedGlobalBuilder2 = builder;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error invoking " + agentRule.getClass().getName() + "#buildAgent(AgentBuilderProvider)", e);
                    }
                }
                if (hasLocal1) {
                    chainedLocalBuilder1.installOn(inst);
                }
                if (!hasLocal2) continue;
                chainedLocalBuilder2.installOn(inst);
            }
            if (hasGlobal1) {
                chainedGlobalBuilder1.installOn(inst);
            }
            if (hasGlobal2) {
                chainedGlobalBuilder2.installOn(inst);
            }
        }
    }

    static class TransformationListener
    implements AgentBuilder.Listener {
        private final Instrumentation inst;
        private final PluginManifest pluginManifest;
        private final Event[] events;

        TransformationListener(Instrumentation inst, PluginManifest pluginManifest, Event[] events) {
            this.inst = inst;
            this.pluginManifest = pluginManifest;
            this.events = events;
        }

        @Override
        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            if (this.events[Event.DISCOVERY.ordinal()] != null) {
                ByteBuddyManager.log(Level.SEVERE, "Event::onDiscovery(" + typeName + ", " + AssembleUtil.getNameId(classLoader) + ", " + module + ", " + loaded + ")");
            }
        }

        @Override
        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            PluginManifest pluginManifest;
            if (this.events[Event.TRANSFORMATION.ordinal()] != null) {
                ByteBuddyManager.log(Level.SEVERE, "Event::onTransformation(" + typeDescription.getName() + ", " + AssembleUtil.getNameId(classLoader) + ", " + module + ", " + loaded + ", " + dynamicType + ")");
            }
            PluginManifest pluginManifest2 = pluginManifest = this.pluginManifest != null ? this.pluginManifest : AgentRule.getPluginManifest(typeDescription);
            if (pluginManifest != null && !SpecialAgent.linkRule(pluginManifest, classLoader)) {
                throw new IncompatiblePluginException(typeDescription.getName());
            }
            if (classLoader != null) {
                try {
                    JavaModule unnamedModule = JavaModule.of(ClassLoader.class.getMethod("getUnnamedModule", new Class[0]).invoke((Object)classLoader, new Object[0]));
                    if (!module.canRead(unnamedModule)) {
                        module.modify(this.inst, Collections.singleton(unnamedModule), Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.EMPTY_MAP);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Added module reads: " + module + " -> " + unnamedModule);
                        }
                    }
                }
                catch (NoSuchMethodException unnamedModule) {
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }

        @Override
        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
            if (this.events[Event.IGNORED.ordinal()] != null) {
                ByteBuddyManager.log(Level.SEVERE, "Event::onIgnored(" + typeDescription.getName() + ", " + AssembleUtil.getNameId(classLoader) + ", " + module + ", " + loaded + ")");
            }
        }

        @Override
        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (this.events[Event.ERROR.ordinal()] != null) {
                ByteBuddyManager.log(Level.SEVERE, "Event::onError(" + typeName + ", " + AssembleUtil.getNameId(classLoader) + ", " + module + ", " + loaded + ")", throwable);
            }
        }

        @Override
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
            if (this.events[Event.COMPLETE.ordinal()] != null) {
                ByteBuddyManager.log(Level.SEVERE, "Event::onComplete(" + typeName + ", " + AssembleUtil.getNameId(classLoader) + ", " + module + ", " + loaded + ")");
            }
        }
    }
}

