/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import java.io.IOException;
import java.util.HashMap;
import net.bytebuddy.dynamic.ClassFileLocator;

public class CachedClassFileLocator
implements ClassFileLocator {
    private final HashMap<String, ClassFileLocator.Resolution> map = new HashMap();

    public CachedClassFileLocator(ClassFileLocator classFileLocator, Class<?> ... classes) throws IOException {
        if (classes == null) {
            return;
        }
        for (int i = 0; i < classes.length; ++i) {
            Class<?> cls = classes[i];
            ClassFileLocator.Resolution resolution = classFileLocator.locate(cls.getName());
            if (resolution instanceof ClassFileLocator.Resolution.Illegal) {
                resolution = ClassFileLocator.ForClassLoader.of(cls.getClassLoader()).locate(cls.getName());
            }
            this.map.put(cls.getName(), resolution);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ClassFileLocator.Resolution locate(String name) throws IOException {
        return this.map.get(name);
    }
}

