/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.BootLoaderAgent;
import io.opentracing.contrib.specialagent.BootProxyClassLoader;
import io.opentracing.contrib.specialagent.CompoundEnumeration;
import io.opentracing.contrib.specialagent.DefaultAgentRule;
import io.opentracing.contrib.specialagent.SpecialAgent;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Set;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class ClassLoaderAgent {
    public static final ClassFileLocator locatorProxy = BootLoaderAgent.cachedLocator;

    public static AgentBuilder premain(AgentBuilder builder) {
        DefaultAgentRule.log("\n<<<<<<<<<<<<<<<<< Installing ClassLoaderAgent >>>>>>>>>>>>>>>>>>\n", null, DefaultAgentRule.DefaultLevel.FINE);
        try {
            AgentBuilder.Identified.Extendable extendable = builder.type(ElementMatchers.isSubTypeOf(ClassLoader.class)).transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit((locatorProxy != null ? Advice.to(DefineClass.class, locatorProxy) : Advice.to(DefineClass.class)).on(ElementMatchers.named("defineClass").and(ElementMatchers.returns(Class.class).and(ElementMatchers.takesArgument(0, String.class))))).visit((locatorProxy != null ? Advice.to(LoadClass.class, locatorProxy) : Advice.to(LoadClass.class)).on(ElementMatchers.named("loadClass").and(ElementMatchers.returns(Class.class).and(ElementMatchers.takesArguments(String.class))))).visit((locatorProxy != null ? Advice.to(FindResource.class, locatorProxy) : Advice.to(FindResource.class)).on(ElementMatchers.named("findResource").and(ElementMatchers.returns(URL.class).and(ElementMatchers.takesArguments(String.class))))).visit((locatorProxy != null ? Advice.to(FindResources.class, locatorProxy) : Advice.to(FindResources.class)).on(ElementMatchers.named("findResources").and(ElementMatchers.returns(Enumeration.class).and(ElementMatchers.takesArguments(String.class)))));
                }
            });
            return extendable;
        }
        finally {
            DefaultAgentRule.log("\n>>>>>>>>>>>>>>>>>> Installed ClassLoaderAgent <<<<<<<<<<<<<<<<<<\n", null, DefaultAgentRule.DefaultLevel.FINE);
        }
    }

    public static boolean isExcluded(ClassLoader thiz) {
        String className = thiz.getClass().getName();
        return className.startsWith("io.opentracing.contrib.specialagent.RuleClassLoader") || className.startsWith("io.opentracing.contrib.specialagent.PluginsClassLoader") || className.startsWith("io.opentracing.contrib.specialagent.AgentRunnerClassLoader") || className.startsWith("io.opentracing.contrib.specialagent.IsoClassLoader");
    }

    public static class FindResources {
        public static final BootLoaderAgent.Mutex mutex = new BootLoaderAgent.Mutex();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit
        public static void exit(@Advice.This ClassLoader thiz, @Advice.Argument(value=0) String name, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Enumeration<URL> returned) {
            if (ClassLoaderAgent.isExcluded(thiz)) {
                return;
            }
            Set visited = (Set)mutex.get();
            if (!visited.add(name)) {
                return;
            }
            try {
                CompoundEnumeration resources = SpecialAgent.findResources(thiz, name);
                if (resources != null) {
                    returned = returned == null ? resources : new CompoundEnumeration(returned, resources);
                }
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> ClassLoaderAgent.FindResources#exit", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
            finally {
                visited.remove(name);
            }
        }
    }

    public static class FindResource {
        public static final BootLoaderAgent.Mutex mutex = new BootLoaderAgent.Mutex();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit
        public static void exit(@Advice.This ClassLoader thiz, @Advice.Argument(value=0) String name, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) URL returned) {
            if (returned != null || ClassLoaderAgent.isExcluded(thiz)) {
                return;
            }
            Set visited = (Set)mutex.get();
            if (!visited.add(name)) {
                return;
            }
            try {
                URL resource = SpecialAgent.findResource(thiz, name);
                if (resource != null) {
                    returned = resource;
                }
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> ClassLoaderAgent.FindResource#exit", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
            finally {
                visited.remove(name);
            }
        }
    }

    public static class LoadClass {
        public static final BootLoaderAgent.Mutex mutex = new BootLoaderAgent.Mutex();
        public static Method defineClass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(onThrowable=ClassNotFoundException.class)
        public static void exit(@Advice.This ClassLoader thiz, @Advice.Argument(value=0) String name, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Class<?> returned, @Advice.Thrown(readOnly=false, typing=Assigner.Typing.DYNAMIC) ClassNotFoundException thrown) {
            if (returned != null || ClassLoaderAgent.isExcluded(thiz)) {
                return;
            }
            Set visited = (Set)mutex.get();
            if (!visited.add(name)) {
                return;
            }
            try {
                Class<?> bootstrapClass = BootProxyClassLoader.INSTANCE.loadClassOrNull(name, false);
                if (bootstrapClass != null) {
                    returned = bootstrapClass;
                    thrown = null;
                    return;
                }
                byte[] bytecode = SpecialAgent.findClass(thiz, name);
                if (bytecode == null) {
                    return;
                }
                if (defineClass == null) {
                    defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                }
                returned = (Class)defineClass.invoke((Object)thiz, name, bytecode, 0, bytecode.length, null);
                thrown = null;
            }
            catch (Throwable t) {
                DefaultAgentRule.log("<><><><> ClassLoaderAgent.LoadClass#exit(\"" + name + "\")", t, DefaultAgentRule.DefaultLevel.SEVERE);
            }
            finally {
                visited.remove(name);
            }
        }
    }

    public static class DefineClass {
        @Advice.OnMethodExit
        public static void exit(@Advice.This ClassLoader thiz) {
            if (!ClassLoaderAgent.isExcluded(thiz)) {
                SpecialAgent.inject(thiz);
            }
        }
    }
}

