/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.Adapter;
import io.opentracing.contrib.specialagent.AgentRule;
import io.opentracing.contrib.specialagent.ClassLoaderAgent;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;

public abstract class DefaultAgentRule
extends AgentRule {
    private static Boolean isAgentRunner;
    private static Logger logger;

    public static void log(String message, Throwable thrown, DefaultLevel level) {
        if ((isAgentRunner == null ? (isAgentRunner = Boolean.valueOf(Adapter.isAgentRunner())) : isAgentRunner).booleanValue()) {
            String logLevel = System.getProperty("sa.log.level");
            if (level == DefaultLevel.SEVERE || logLevel != null && logLevel.startsWith("FINE")) {
                System.err.println(message);
                if (thrown != null) {
                    thrown.printStackTrace(System.err);
                }
            }
        } else {
            if (logger == null) {
                logger = Logger.getLogger(ClassLoaderAgent.class);
            }
            if (level == DefaultLevel.SEVERE) {
                logger.log(Level.SEVERE, message, thrown);
            } else if (level == DefaultLevel.FINE && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, message, thrown);
            } else if (level == DefaultLevel.FINEST && logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, message, thrown);
            }
        }
    }

    public static enum DefaultLevel {
        SEVERE,
        FINE,
        FINEST;

    }
}

