/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.BiConsumer;
import io.opentracing.contrib.specialagent.BootProxyClassLoader;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;

public class IsoClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(IsoClassLoader.class);
    private static BiConsumer<String, HashSet<String>> classNameConsumer = new BiConsumer<String, HashSet<String>>(){

        @Override
        public void accept(String name, HashSet<String> arg) {
            if (BootProxyClassLoader.INSTANCE.getResource(name) == null) {
                arg.add(name);
            }
        }
    };

    public IsoClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)new IsoParentClassLoader(urls, parent));
    }

    public Class<?> loadClassOrNull(String name) {
        try {
            return this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class IsoParentClassLoader
    extends ClassLoader {
        private final AtomicReference<HashSet<String>> isoNames = new AtomicReference();
        private final URL[] isoClassPaths;

        private IsoParentClassLoader(URL[] isoClassPaths, ClassLoader parent) {
            super(parent);
            this.isoClassPaths = isoClassPaths;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("new IsoParentClassLoader(" + AssembleUtil.toIndentedString(isoClassPaths) + ")");
            }
        }

        private HashSet<String> getNames() {
            if (this.isoNames.get() != null) {
                return this.isoNames.get();
            }
            IsoParentClassLoader isoParentClassLoader = this;
            synchronized (isoParentClassLoader) {
                if (this.isoNames.get() != null) {
                    return this.isoNames.get();
                }
                HashSet<String> names = new HashSet<String>();
                try {
                    AssembleUtil.forEachClass(this.isoClassPaths, names, classNameConsumer);
                    this.isoNames.set(names);
                    return names;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cls;
            boolean isNameIso = this.getNames().contains(AssembleUtil.classNameToResource(name));
            Class<?> clazz = cls = isNameIso ? null : super.loadClass(name, resolve);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("~~~~~~~~ IsoParentClassLoader.loadClass(\"" + name + "\", " + resolve + ") [" + isNameIso + "]: " + cls);
            }
            return cls;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> resources;
            boolean isNameIso = this.getNames().contains(name);
            Enumeration<URL> enumeration = resources = isNameIso ? Collections.emptyEnumeration() : super.getResources(name);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("~~~~~~~~ IsoParentClassLoader.getResources(\"" + name + "\") [" + isNameIso + "]: " + resources);
            }
            return resources;
        }
    }
}

