/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import java.util.Objects;

public enum Level {
    ALL(0),
    FINEST(300),
    FINER(400),
    FINE(500),
    CONFIG(700),
    INFO(800),
    WARNING(900),
    SEVERE(1000),
    OFF(Integer.MAX_VALUE);

    private final int value;

    public static Level parse(String str) {
        Objects.requireNonNull(str);
        for (Level level : Level.values()) {
            if (!str.equalsIgnoreCase(level.name()) && !str.equals(String.valueOf(level.value))) continue;
            return level;
        }
        throw new IllegalArgumentException("Bad level \"" + str + "\"");
    }

    private Level(int value) {
        this.value = value;
    }

    boolean isLoggable(Level level) {
        return this.value <= (level != null ? level.value : Level.INFO.value);
    }
}

