/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.Level;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;

public class Logger {
    private static String REFRESH_PREFIX = "sa.log.refresh.";
    private static final String LOG_REFRESH_PROPERTY = REFRESH_PREFIX + Logger.class.hashCode();
    static final String LOG_LEVEL_PROPERTY = "sa.log.level";
    static final String LOG_FILE_PROPERTY = "sa.log.file";
    private static final Logger logger = new Logger();
    private static Level level = Level.INFO;
    private static PrintStream out = System.err;

    private static void recurseClearProperty(Iterator<Map.Entry<Object, Object>> iterator) {
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = String.valueOf(entry.getKey());
            if (!key.startsWith(REFRESH_PREFIX)) continue;
            Logger.recurseClearProperty(iterator);
            System.clearProperty(key);
        }
    }

    static void refreshLoggers() {
        Logger.recurseClearProperty(System.getProperties().entrySet().iterator());
    }

    static void init() {
        String logFileProperty;
        String logLevelProperty = System.getProperty(LOG_LEVEL_PROPERTY);
        if (logLevelProperty != null) {
            Logger.setLevel(Level.parse(logLevelProperty));
        }
        if ((logFileProperty = System.getProperty(LOG_FILE_PROPERTY)) != null) {
            try {
                Logger.setOut(new PrintStream(new FileOutputStream(logFileProperty), true));
            }
            catch (FileNotFoundException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static void refresh() {
        if (System.getProperty(LOG_REFRESH_PROPERTY) == null) {
            System.setProperty(LOG_REFRESH_PROPERTY, "");
            Logger.init();
        }
    }

    public static Logger getLogger(Class<?> cls) {
        return logger;
    }

    public static void setLevel(Level level) {
        Logger.level = level != null ? level : Level.INFO;
    }

    public static void setOut(PrintStream out) {
        Logger.out = out;
    }

    public boolean isLoggable(Level level) {
        Logger.refresh();
        return Logger.level.isLoggable(level);
    }

    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            out.println(msg);
        }
    }

    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            out.println(msg);
        }
    }

    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            out.println(msg);
        }
    }

    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            out.println(msg);
        }
    }

    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            out.println(msg);
        }
    }

    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            out.println(msg);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            out.println(msg);
            if (thrown != null) {
                thrown.printStackTrace(out);
            }
        }
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            out.println(msg);
        }
    }

    protected Logger() {
    }

    static {
        Logger.init();
    }
}

