/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.MavenUtil;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.model.Dependency;

public class MavenDependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type = "jar";

    public static Dependency[] toDependencies(Collection<? extends MavenDependency> dependencies) {
        Dependency[] result = new Dependency[dependencies.size()];
        Iterator<? extends MavenDependency> iterator = dependencies.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            result[i] = iterator.next().toDependency();
            ++i;
        }
        return result;
    }

    public MavenDependency(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public MavenDependency(String groupId, String artifactId, String version, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
    }

    public MavenDependency() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Dependency toDependency() {
        return MavenUtil.newDependency(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getClassifier(), this.getType());
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.groupId != null) {
            hashCode = hashCode * 37 + this.groupId.hashCode();
        }
        if (this.artifactId != null) {
            hashCode = hashCode * 37 + this.artifactId.hashCode();
        }
        if (this.version != null) {
            hashCode = hashCode * 37 + this.version.hashCode();
        }
        if (this.classifier != null) {
            hashCode = hashCode * 37 + this.classifier.hashCode();
        }
        if (this.type != null) {
            hashCode = hashCode * 37 + this.type.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        MavenDependency that = (MavenDependency)obj;
        if (this.getGroupId() != null ? !this.getGroupId().equals(that.getGroupId()) : that.getGroupId() != null) {
            return false;
        }
        if (this.getArtifactId() != null ? !this.getArtifactId().equals(that.getArtifactId()) : that.getArtifactId() != null) {
            return false;
        }
        if (this.getVersion() != null ? !this.getVersion().equals(that.getVersion()) : that.getVersion() != null) {
            return false;
        }
        if (this.getClassifier() != null ? !this.getClassifier().equals(that.getClassifier()) : that.getClassifier() != null) {
            return false;
        }
        return !(this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.groupId).append(':');
        builder.append(this.artifactId).append(':');
        builder.append(this.type).append(':');
        if (this.classifier != null) {
            builder.append(this.classifier).append(':');
        }
        builder.append(this.version);
        return builder.toString();
    }
}

