/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.MavenDependency;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class MavenUtil {
    private static final Set<String> jarTypes = new HashSet<String>(Arrays.asList("jar", "test-jar", "maven-plugin", "ejb", "ejb-client", "java-source", "javadoc"));
    private static final String[] scopes = new String[]{"compile", "provided", "runtime", "system", "test", "isolated"};

    private static boolean isScope(String scope) {
        for (int i = 0; i < scopes.length; ++i) {
            if (!scopes[i].equals(scope)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (!(obj == null ? array[i] == null : obj.equals(array[i]))) continue;
            return true;
        }
        return false;
    }

    public static MavenDependency getDependency(String dependency, String ... scopes) {
        String scope;
        int c4;
        int c0 = dependency.indexOf(58);
        String groupId = dependency.substring(0, c0);
        int c1 = dependency.indexOf(58, c0 + 1);
        String artifactId = dependency.substring(c0 + 1, c1);
        int c2 = dependency.indexOf(58, c1 + 1);
        String type = dependency.substring(c1 + 1, c2);
        int c3 = dependency.indexOf(58, c2 + 1);
        String classifierOrVersion = dependency.substring(c2 + 1, c3 > c2 ? c3 : dependency.length());
        int n = c4 = c3 == -1 ? -1 : dependency.indexOf(58, c3 + 1);
        String versionOrScope = c3 == -1 ? null : dependency.substring(c3 + 1, c4 > c3 ? c4 : dependency.length());
        String string = scope = c4 == -1 ? null : dependency.substring(c4 + 1);
        if (scope != null) {
            if (scopes != null && !MavenUtil.contains(scopes, scope)) {
                return null;
            }
            return new MavenDependency(groupId, artifactId, versionOrScope, classifierOrVersion, type);
        }
        if (versionOrScope != null) {
            boolean isScope = MavenUtil.isScope(versionOrScope);
            if (scopes != null && (isScope ? !MavenUtil.contains(scopes, versionOrScope) : !MavenUtil.contains(scopes, "compile"))) {
                return null;
            }
            if (isScope) {
                return new MavenDependency(groupId, artifactId, classifierOrVersion, null, type);
            }
            return new MavenDependency(groupId, artifactId, versionOrScope, classifierOrVersion, type);
        }
        if (scopes != null && !MavenUtil.contains(scopes, "compile")) {
            return null;
        }
        return new MavenDependency(groupId, artifactId, classifierOrVersion, null, type);
    }

    public static Set<File> selectFromTgf(String tgf, boolean isOptional, String ... scopes) throws IOException {
        Set<MavenDependency> dependencies = MavenUtil.selectDependenciesFromTgf(tgf, isOptional, scopes);
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (MavenDependency dependency : dependencies) {
            File file = new File(MavenUtil.getPathOf(null, dependency));
            files.add(file);
        }
        return files;
    }

    public static Set<MavenDependency> selectDependenciesFromTgf(String tgf, boolean isOptional, String ... scopes) {
        LinkedHashSet<MavenDependency> dependencies = new LinkedHashSet<MavenDependency>();
        StringTokenizer tokenizer = new StringTokenizer(tgf, "\r\n");
        boolean includesCompileScope = MavenUtil.contains(scopes, "compile");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            block6: {
                MavenDependency dependency;
                String token;
                block8: {
                    boolean matchOptionalCompile;
                    block7: {
                        token = tokenizer.nextToken().trim();
                        boolean bl = matchOptionalCompile = i == 0 && isOptional && includesCompileScope;
                        if (i == 0 && !matchOptionalCompile) break block6;
                        if ("#".equals(token)) break;
                        boolean optional = token.endsWith(" (optional)");
                        if (!optional) break block7;
                        if (!isOptional) break block6;
                        token = token.substring(0, token.length() - 11);
                        break block8;
                    }
                    if (isOptional && !matchOptionalCompile) break block6;
                }
                int firstSpace = token.indexOf(32);
                int lastSpace = token.indexOf(32, firstSpace + 1);
                if (lastSpace == -1) {
                    lastSpace = token.length();
                }
                if ((dependency = MavenUtil.getDependency(token.substring(firstSpace + 1, lastSpace), scopes)) != null) {
                    dependencies.add(dependency);
                }
            }
            ++i;
        }
        return dependencies;
    }

    private static String getExtension(String type) {
        return type == null || jarTypes.contains(type) ? "jar" : type;
    }

    public static DefaultArtifact clone(Artifact artifact) {
        DefaultArtifact clone = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope(), artifact.getType(), artifact.getClassifier(), artifact.getArtifactHandler());
        clone.setAvailableVersions(artifact.getAvailableVersions());
        clone.setBaseVersion(artifact.getBaseVersion());
        clone.setDependencyFilter(artifact.getDependencyFilter());
        clone.setDependencyTrail(artifact.getDependencyTrail());
        clone.setDownloadUrl(artifact.getDownloadUrl());
        clone.setFile(artifact.getFile());
        clone.setOptional(artifact.isOptional());
        clone.setRelease(artifact.isRelease());
        clone.setRepository(artifact.getRepository());
        clone.setResolved(artifact.isResolved());
        clone.setVersionRange(artifact.getVersionRange());
        return clone;
    }

    public static Dependency newDependency(String groupId, String artifactId, String version) {
        return MavenUtil.newDependency(groupId, artifactId, version, null, null);
    }

    public static Dependency newDependency(String groupId, String artifactId, String version, String classifier, String type) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setClassifier(classifier);
        if (type != null) {
            dependency.setType(type);
        }
        return dependency;
    }

    public static boolean isInTestPhase(MojoExecution execution) {
        return execution.getLifecyclePhase() != null && execution.getLifecyclePhase().contains("test");
    }

    public static PluginExecution getPluginExecution(MojoExecution execution) {
        Plugin plugin = execution.getPlugin();
        plugin.flushExecutionMap();
        for (PluginExecution pluginExecution : plugin.getExecutions()) {
            if (!pluginExecution.getId().equals(execution.getExecutionId())) continue;
            return pluginExecution;
        }
        return null;
    }

    public static boolean shouldSkip(MojoExecution execution, boolean mavenTestSkip) {
        if (!mavenTestSkip) {
            return false;
        }
        if (execution != null && MavenUtil.isInTestPhase(execution)) {
            return true;
        }
        PluginExecution pluginExecution = MavenUtil.getPluginExecution(execution);
        return pluginExecution != null && pluginExecution.getPhase() != null && pluginExecution.getPhase().contains("test");
    }

    public static String lookupVersion(MavenProject project, MavenDependency mavenDependency) throws MojoExecutionException {
        DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
        if (dependencyManagement != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                if (!dependency.getGroupId().equals(mavenDependency.getGroupId()) || !dependency.getArtifactId().equals(mavenDependency.getArtifactId())) continue;
                return dependency.getVersion();
            }
        }
        if (project.getParent() == null) {
            throw new MojoExecutionException("Was not able to find the version of: " + mavenDependency.getGroupId() + ":" + mavenDependency.getArtifactId());
        }
        return MavenUtil.lookupVersion(project.getParent(), mavenDependency);
    }

    public static String getPathOf(String localRepositoryPath, Artifact artifact) {
        return MavenUtil.getPathOf(localRepositoryPath, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType());
    }

    public static String getPathOf(String localRepositoryPath, MavenDependency dependency) {
        return MavenUtil.getPathOf(localRepositoryPath, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
    }

    public static String getPathOf(String localRepositoryPath, String groupId, String artifactId, String version, String classifier, String type) {
        StringBuilder builder = new StringBuilder();
        if (localRepositoryPath != null) {
            builder.append(localRepositoryPath);
            builder.append(File.separatorChar);
        }
        builder.append(groupId.replace('.', File.separatorChar));
        builder.append(File.separatorChar);
        builder.append(artifactId);
        builder.append(File.separatorChar);
        builder.append(version);
        builder.append(File.separatorChar);
        builder.append(artifactId);
        builder.append('-').append(version);
        if (classifier != null) {
            builder.append('-').append(classifier);
        }
        return builder.append('.').append(MavenUtil.getExtension(type)).toString();
    }

    private static Model getModel(File pomFile) throws IOException, XmlPullParserException {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        return reader.read((Reader)new FileReader(pomFile));
    }

    public static String getArtifactVersion(File dir) {
        try {
            Model model = MavenUtil.getModel(new File(dir, "pom.xml"));
            return model.getVersion() != null ? model.getVersion() : model.getParent().getVersion();
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getArtifactFile(File dir) {
        try {
            Model model = MavenUtil.getModel(new File(dir, "pom.xml"));
            String version = model.getVersion() != null ? model.getVersion() : model.getParent().getVersion();
            return model.getArtifactId() + "-" + version + ".jar";
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File[] filterUrlFileNames(File[] files, Set<File> matches, int index, int depth) {
        for (int i = index; i < files.length; ++i) {
            String artifact;
            File file = files[i];
            if (file.isDirectory() && "target".equals(file.getParentFile().getName()) && "classes".equals(file.getName())) {
                artifact = MavenUtil.getArtifactFile(file.getParentFile().getParentFile());
            } else {
                if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                artifact = file.getName();
            }
            for (File match : matches) {
                if (!artifact.equals(match.getName())) continue;
                File[] results = MavenUtil.filterUrlFileNames(files, matches, i + 1, depth + 1);
                results[depth] = file;
                return results;
            }
        }
        return depth == 0 ? null : new File[depth];
    }

    public static File[] filterRuleURLs(File[] files, String dependenciesTgf, boolean includeOptional, String ... scopes) throws IOException {
        Set<File> matches = MavenUtil.selectFromTgf(dependenciesTgf, includeOptional, scopes);
        return MavenUtil.filterUrlFileNames(files, matches, 0, 0);
    }

    private MavenUtil() {
    }
}

