/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.Tracer;
import io.opentracing.contrib.specialagent.Adapter;
import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.TestUtil;
import io.opentracing.contrib.specialagent.TracerClassLoader;
import io.opentracing.mock.MockTracer;
import io.opentracing.mock.ProxyMockTracer;
import io.opentracing.util.GlobalTracer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;

public class OpenTracingAdapter
extends Adapter {
    private static final Logger logger = Logger.getLogger(OpenTracingAdapter.class);
    private static final String TRACER_FACTORY = "META-INF/services/io.opentracing.contrib.tracerresolver.TracerFactory";
    private boolean loaded;
    private Tracer deferredTracer;
    private static final Object tracerMutex = new Object();
    private Tracer tracer;
    private static final String[] traceExcludedClasses = new String[]{"io.opentracing.Tracer", "io.opentracing.Scope", "io.opentracing.ScopeManager", "io.opentracing.Span", "io.opentracing.SpanBuilder", "io.opentracing.SpanContext"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tracer getAgentRunnerTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        Object object = tracerMutex;
        synchronized (object) {
            MockTracer tracer;
            if (this.tracer != null) {
                return this.tracer;
            }
            if (GlobalTracer.isRegistered()) {
                Tracer registered = TestUtil.getGlobalTracer();
                if (this.deferredTracer == null) {
                    tracer = registered instanceof MockTracer ? (MockTracer)registered : new ProxyMockTracer(registered);
                } else if (registered instanceof MockTracer) {
                    tracer = new ProxyMockTracer((MockTracer)registered, this.deferredTracer);
                } else {
                    throw new IllegalStateException("There is already a registered global Tracer.");
                }
                TestUtil.setGlobalTracer(tracer);
            } else {
                MockTracer mockTracer = tracer = this.deferredTracer != null ? new ProxyMockTracer(this.deferredTracer) : new MockTracer();
                if (!GlobalTracer.registerIfAbsent(tracer)) {
                    throw new IllegalStateException("There is already a registered global Tracer.");
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Registering tracer for AgentRunner: " + tracer);
                logger.finer("  Tracer ClassLoader: " + tracer.getClass().getClassLoader());
                logger.finer("  Tracer Location: " + ClassLoader.getSystemClassLoader().getResource(AssembleUtil.classNameToResource(tracer.getClass())));
                logger.finer("  GlobalTracer ClassLoader: " + GlobalTracer.class.getClassLoader());
                logger.finer("  GlobalTracer Location: " + ClassLoader.getSystemClassLoader().getResource(AssembleUtil.classNameToResource(GlobalTracer.class)));
            }
            this.tracer = tracer;
            return this.tracer;
        }
    }

    @Override
    public String[] loadTracer(ClassLoader isoClassLoader) {
        if (!this.loaded) {
            try {
                this.loaded = true;
                this.deferredTracer = OpenTracingAdapter.loadDeferredTracer(isoClassLoader);
            }
            catch (IOException | ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        return traceExcludedClasses;
    }

    private static URL findTracer(ClassLoader classLoader, String name) throws IOException {
        Enumeration<URL> enumeration = classLoader.getResources(TRACER_FACTORY);
        HashSet<URL> urls = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            String jarPath;
            String fileName;
            String tracerName;
            URL url = enumeration.nextElement();
            if (urls.contains(url)) continue;
            urls.add(url);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found META-INF/services/io.opentracing.contrib.tracerresolver.TracerFactory: <" + AssembleUtil.getNameId(url) + ">" + url);
            }
            if (!name.equals(tracerName = (fileName = AssembleUtil.getName(jarPath = AssembleUtil.getSourceLocation(url, TRACER_FACTORY).getPath())).substring(0, fileName.lastIndexOf(46)))) continue;
            return new URL("file", null, jarPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tracer loadDeferredTracer(ClassLoader isoClassLoader) throws IOException, ReflectiveOperationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("\n<<<<<<<<<<<<<<<<<<<< Loading Trace Exporter >>>>>>>>>>>>>>>>>>>>\n");
        }
        try {
            Tracer tracer;
            Tracer tracer2;
            if (GlobalTracer.isRegistered()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Tracer already registered with GlobalTracer");
                }
                Tracer tracer3 = null;
                return tracer3;
            }
            String exporterProperty = System.getProperty("sa.exporter");
            if (exporterProperty == null && (exporterProperty = System.getProperty("sa.tracer")) != null) {
                logger.warning("Deprecated key (as of v1.7.0): \"sa.tracer\" should be changed to \"sa.exporter\"");
            }
            if (exporterProperty == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Trace exporter was not specified with \"sa.exporter\" system property");
                }
                Tracer tracer4 = null;
                return tracer4;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Resolving tracer:\n  " + exporterProperty);
            }
            if ("mock".equals(exporterProperty)) {
                tracer2 = new MockTracer();
            } else {
                URL tracerUrl;
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                File file = new File(exporterProperty);
                URL uRL = tracerUrl = file.exists() ? new URL("file", null, file.getPath()) : OpenTracingAdapter.findTracer(isoClassLoader, exporterProperty);
                if (tracerUrl == null) {
                    throw new IllegalStateException("sa.exporter=" + exporterProperty + " did not resolve to a tracer JAR or name");
                }
                String tracerResolverUrl = isoClassLoader.getResource("io/opentracing/contrib/tracerresolver/TracerResolver.class").toString();
                Adapter.tracerClassLoader = new TracerClassLoader(null, tracerUrl, new URL(tracerResolverUrl.substring(4, tracerResolverUrl.indexOf(33))));
                Thread.currentThread().setContextClassLoader(Adapter.tracerClassLoader);
                Class<?> tracerResolverClass = Class.forName("io.opentracing.contrib.tracerresolver.TracerResolver", true, Adapter.tracerClassLoader);
                Method resolveTracerMethod = tracerResolverClass.getMethod("resolveTracer", new Class[0]);
                tracer2 = (Tracer)resolveTracerMethod.invoke(null, new Object[0]);
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            if (tracer2 == null) {
                logger.warning("Trace exporter was NOT RESOLVED");
                tracer = null;
                return tracer;
            }
            tracer2 = OpenTracingAdapter.initRewritableTracer(tracer2, isoClassLoader);
            if (!OpenTracingAdapter.isAgentRunner() && !GlobalTracer.registerIfAbsent(tracer2)) {
                throw new IllegalStateException("There is already a registered global Tracer.");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Tracer was resolved and " + (OpenTracingAdapter.isAgentRunner() ? "deferred to be registered" : "registered") + " with GlobalTracer:\n  " + tracer2.getClass().getName() + " from " + (tracer2.getClass().getProtectionDomain().getCodeSource() == null ? "null" : tracer2.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()));
            }
            tracer = tracer2;
            return tracer;
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("\n>>>>>>>>>>>>>>>>>>>> Loaded Trace Exporter <<<<<<<<<<<<<<<<<<<<<\n");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Tracer initRewritableTracer(Tracer tracer, ClassLoader isoClassLoader) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

