/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.BiFunction;
import io.opentracing.contrib.specialagent.Function;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginManifest {
    private static final Logger logger = Logger.getLogger(PluginManifest.class);
    private static final String RULE_NAME_PROPERTY = "sa.rule.name.";
    private static BiFunction<Path, Path, String> pathToClassName = new BiFunction<Path, Path, String>(){

        @Override
        public String apply(Path t, Path u) {
            try {
                return new String(Files.readAllBytes(u));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private static BiFunction<JarFile, JarEntry, String> jarToClassName = new BiFunction<JarFile, JarEntry, String>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String apply(JarFile t, JarEntry u) {
            try (InputStream in = t.getInputStream(u);){
                String string = new String(AssembleUtil.readBytes(in));
                return string;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    public final File file;
    public final Type type;
    public final String name;
    public final String adapterClassName;
    private URL fingerprintUrl;
    private int priority = -1;
    private final HashMap<ClassLoader, Boolean> classLoaderToCompatibility = new HashMap();

    private static <D, P> PluginManifest getPluginManifestFromEntry(File file, String entry, D dir, P path, BiFunction<D, P, String> entryToContent) {
        if (entry.startsWith(RULE_NAME_PROPERTY)) {
            return new PluginManifest(file, Type.INSTRUMENTATION, entry.substring(RULE_NAME_PROPERTY.length()), entryToContent.apply(dir, path));
        }
        if ("META-INF/services/io.opentracing.contrib.tracerresolver.TracerFactory".equals(entry)) {
            return new PluginManifest(file, Type.TRACER, file.getName().substring(0, file.getName().length() - 4), null);
        }
        return null;
    }

    public static PluginManifest id(File file) {
        return new PluginManifest(file, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginManifest getPluginManifest(final File file) {
        if (file.isDirectory()) {
            final PluginManifest[] pluginManifest = new PluginManifest[1];
            final Path dir = file.toPath();
            AssembleUtil.recurseDir(file, new Function<File, FileVisitResult>(){

                @Override
                public FileVisitResult apply(File t) {
                    Path path = t.toPath();
                    String entry = dir.relativize(path).toString();
                    if (entry.contains("/") && !entry.startsWith("META-INF")) {
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                    pluginManifest[0] = PluginManifest.getPluginManifestFromEntry(file, entry, dir, path, pathToClassName);
                    return pluginManifest[0] != null ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }
            });
            return pluginManifest[0];
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                PluginManifest pluginManifest = PluginManifest.getPluginManifestFromEntry(file, entry.getName(), jarFile, entry, jarToClassName);
                if (pluginManifest == null) continue;
                PluginManifest pluginManifest2 = pluginManifest;
                return pluginManifest2;
            }
            PluginManifest pluginManifest = null;
            return pluginManifest;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private PluginManifest(File file, Type type, String name, String adapterClassName) {
        this.file = file.getAbsoluteFile();
        this.type = type;
        this.name = name;
        this.adapterClassName = adapterClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPriority() {
        if (this.priority != -1) {
            return this.priority;
        }
        try {
            String pom = null;
            if (this.file.isDirectory()) {
                pom = new String(Files.readAllBytes(new File(new File(this.file, "../.."), "pom.xml").toPath()));
            } else {
                try (ZipFile zipFile = new ZipFile(this.file);){
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        if (!entry.getName().startsWith("META-INF/maven/") || !entry.getName().endsWith("pom.xml")) continue;
                        try (InputStream in = zipFile.getInputStream(entry);){
                            pom = new String(AssembleUtil.readBytes(in));
                            break;
                        }
                    }
                }
                if (pom == null) {
                    throw new FileNotFoundException("Could not find META-INF/maven/.../pom.xml in " + this.file);
                }
            }
            int start = pom.indexOf("<sa.rule.priority>");
            if (start == -1) {
                this.priority = 0;
                return 0;
            }
            int end = pom.indexOf("</sa.rule.priority>", start + 18);
            this.priority = Integer.parseInt(pom.substring(start + 18, end));
            if (this.priority < 0) {
                throw new IllegalArgumentException("sa.rule.priority must be between 0 and 2147483647");
            }
            return this.priority;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public URL getFingerprint() {
        try {
            return this.fingerprintUrl == null ? (this.fingerprintUrl = new URL(this.file.isDirectory() ? "file:" + this.file + "/fingerprint.bin" : "jar:file:" + this.file + "!/fingerprint.bin")) : this.fingerprintUrl;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<ClassLoader, Boolean> getClassLoaderToCompatibility() {
        return this.classLoaderToCompatibility;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PluginManifest)) {
            return false;
        }
        PluginManifest that = (PluginManifest)obj;
        return this.file.equals(that.file);
    }

    static enum Type {
        INSTRUMENTATION,
        TRACER;

    }

    public static class Directory {
        private static final Comparator<PluginManifest> comparator = new Comparator<PluginManifest>(){

            @Override
            public int compare(PluginManifest o1, PluginManifest o2) {
                return Integer.compare(o1.getPriority(), o2.getPriority());
            }
        };
        private final LinkedHashMap<File, PluginManifest> fileToPluginManifest = new LinkedHashMap();

        public void put(File file, PluginManifest pluginManifest) {
            if (pluginManifest != null) {
                file = pluginManifest.file;
            }
            this.fileToPluginManifest.put(file, pluginManifest);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("PluginManifest.put(" + file + " <" + file.getAbsoluteFile() + ">, " + AssembleUtil.getSimpleNameId(pluginManifest) + ")");
            }
        }

        public boolean containsKey(File file) {
            boolean result = this.fileToPluginManifest.containsKey(file.getAbsoluteFile());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("PluginManifest.contains(" + file + " <" + file.getAbsoluteFile() + ">): " + result);
            }
            return result;
        }

        public Set<File> keySet() {
            return this.fileToPluginManifest.keySet();
        }

        public PluginManifest get(File file) {
            PluginManifest result = this.fileToPluginManifest.get(file.getAbsoluteFile());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("PluginManifest.get(" + file + " <" + file.getAbsoluteFile() + ">): " + AssembleUtil.getSimpleNameId(result));
            }
            return result;
        }

        public int size() {
            return this.fileToPluginManifest.size();
        }

        public void sort() {
            ArrayList<PluginManifest> pluginManifests = new ArrayList<PluginManifest>();
            Iterator<Map.Entry<File, PluginManifest>> iterator = this.fileToPluginManifest.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, PluginManifest> entry = iterator.next();
                if (entry.getValue() == null) continue;
                pluginManifests.add(entry.getValue());
                iterator.remove();
            }
            Collections.sort(pluginManifests, comparator);
            for (PluginManifest pluginManifest : pluginManifests) {
                this.fileToPluginManifest.put(pluginManifest.file, pluginManifest);
            }
        }
    }
}

