/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.BiConsumer;
import io.opentracing.contrib.specialagent.BootProxyClassLoader;
import io.opentracing.contrib.specialagent.ClassLoaderMap;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.PluginManifest;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

class RuleClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(RuleClassLoader.class);
    private static final String SKIP_FINGERPRINT = "sa.fingerprint.skip";
    private static final boolean skipFingerprint = AssembleUtil.isSystemProperty("sa.fingerprint.skip", null);
    private static final BiConsumer<String, ClassLoader> loadClass = new BiConsumer<String, ClassLoader>(){

        @Override
        public void accept(String path, ClassLoader classLoader) {
            String className = AssembleUtil.resourceToClassName(path);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Class.forName(\"" + className + "\", false, " + AssembleUtil.getNameId(classLoader) + ")");
            }
            try {
                Class.forName(className, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    };
    private final ClassLoaderMap<Boolean> compatibility = new ClassLoaderMap();
    private final ClassLoaderMap<Boolean> injected = new ClassLoaderMap();
    private final PluginManifest pluginManifest;
    private final ClassLoader isoClassLoader;

    RuleClassLoader(PluginManifest pluginManifest, ClassLoader isoClassLoader, ClassLoader parent, File ... files) {
        super(AssembleUtil.toURLs(files), parent);
        this.pluginManifest = pluginManifest;
        this.isoClassLoader = isoClassLoader;
        if (parent == null || parent == ClassLoader.getSystemClassLoader()) {
            this.injected.put(parent, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inject(ClassLoader classLoader) {
        if (this.injected.containsKey(classLoader)) {
            return;
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            if (this.injected.containsKey(classLoader)) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RuleClassLoader<" + AssembleUtil.getNameId(this) + ">.inject(" + AssembleUtil.getNameId(classLoader) + ")");
            }
            try {
                this.injected.put(classLoader, Boolean.FALSE);
                AssembleUtil.forEachClass(this.getURLs(), classLoader, loadClass);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.injected.put(classLoader, Boolean.TRUE);
            }
        }
    }

    boolean isClosed(ClassLoader classLoader) {
        Boolean preLoaded = this.injected.get(classLoader);
        return preLoaded != null && preLoaded != false;
    }

    boolean isCompatible(ClassLoader classLoader) {
        Boolean compatible;
        if (classLoader == null) {
            classLoader = BootProxyClassLoader.INSTANCE;
        }
        if ((compatible = this.compatibility.get(classLoader)) != null) {
            return compatible;
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            compatible = this.compatibility.get(classLoader);
            if (compatible != null) {
                return compatible;
            }
            try {
                compatible = this.isFingerprintCompatible(classLoader);
                if (!compatible.booleanValue()) {
                    this.close();
                }
                this.compatibility.put(classLoader, compatible);
                return compatible;
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private boolean isFingerprintCompatible(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (skipFingerprint) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Allowing integration with \"" + this.pluginManifest.name + "\" due to \"-D" + SKIP_FINGERPRINT + "=true\"");
            }
            return true;
        }
        Class<?> libraryFingerprintClass = this.isoClassLoader.loadClass("io.opentracing.contrib.specialagent.LibraryFingerprint");
        Method fromFileMethod = libraryFingerprintClass.getDeclaredMethod("fromFile", URL.class);
        Object fingerprint = fromFileMethod.invoke(null, this.pluginManifest.getFingerprint());
        if (fingerprint != null) {
            Method isCompatibleMethod = libraryFingerprintClass.getDeclaredMethod("isCompatible", ClassLoader.class);
            List errors = (List)isCompatibleMethod.invoke(fingerprint, classLoader);
            if (errors != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Disallowing integration with \"" + this.pluginManifest.name + "\" due to \"" + "fingerprint.bin" + " mismatch\" errors:\n" + AssembleUtil.toIndentedString(errors) + "\nin:\n" + AssembleUtil.toIndentedString(this.getURLs()));
                }
                return false;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Allowing integration with \"" + this.pluginManifest.name + "\" due to \"" + "fingerprint.bin" + " match\" for:\n" + AssembleUtil.toIndentedString(this.getURLs()));
            }
            return true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Allowing integration with \"" + this.pluginManifest.name + "\" due to \"" + "fingerprint.bin" + " not found\"\nin:\n" + AssembleUtil.toIndentedString(this.getURLs()));
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.getURLs());
    }
}

