/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import com.sun.tools.attach.VirtualMachine;
import io.opentracing.contrib.specialagent.Adapter;
import io.opentracing.contrib.specialagent.AgentRule;
import io.opentracing.contrib.specialagent.AgentRule$;
import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.BootLoaderAgent;
import io.opentracing.contrib.specialagent.ClassLoaderMap;
import io.opentracing.contrib.specialagent.Event;
import io.opentracing.contrib.specialagent.IdentityList;
import io.opentracing.contrib.specialagent.Instrumenter;
import io.opentracing.contrib.specialagent.IntegrationRule;
import io.opentracing.contrib.specialagent.IsoClassLoader;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.Manager;
import io.opentracing.contrib.specialagent.MavenUtil;
import io.opentracing.contrib.specialagent.PluginManifest;
import io.opentracing.contrib.specialagent.PluginsClassLoader;
import io.opentracing.contrib.specialagent.Predicate;
import io.opentracing.contrib.specialagent.QuadFunction;
import io.opentracing.contrib.specialagent.RuleClassLoader;
import io.opentracing.contrib.specialagent.SpecialAgentUtil;
import io.opentracing.contrib.specialagent.Supplier;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class SpecialAgent {
    private static final Logger logger = Logger.getLogger(SpecialAgent.class);
    private static final String DEFINE_CLASS = ClassLoader.class.getName() + ".defineClass";
    private static final PluginManifest.Directory pluginManifestDirectory = new PluginManifest.Directory();
    private static final ClassLoaderMap<List<RuleClassLoader>> classLoaderToRuleClassLoader = new ClassLoaderMap();
    private static final HashMap<File, File[]> pluginFileToDependencies = new HashMap();
    private static PluginsClassLoader pluginsClassLoader;
    public static IsoClassLoader isoClassLoader;
    private static final Instrumenter instrumenter;
    private static Instrumentation inst;
    private static final long startTime;
    private static final HashSet<Class<?>> adapterClasses;
    private static final QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, Boolean, RuntimeException> inject;
    private static final QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, byte[], RuntimeException> findClass;
    private static final QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, URL, RuntimeException> findResource;
    private static final QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, Enumeration<URL>, IOException> findResources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: <PID>");
            System.exit(1);
        }
        VirtualMachine vm = VirtualMachine.attach(args[0]);
        String agentPath = SpecialAgent.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        StringBuilder inputArguments = SpecialAgentUtil.getInputArguments();
        int logFileProperty = inputArguments.indexOf("-Dsa.log.file=");
        if (logFileProperty > 0) {
            int start = logFileProperty + 14;
            int end = Math.max(inputArguments.indexOf(" ", start), inputArguments.length());
            String filePath = inputArguments.substring(start, end);
            inputArguments.replace(start, end, new File(filePath).getAbsolutePath());
        }
        if (inputArguments.length() > 0) {
            inputArguments.append(' ');
        }
        inputArguments.append("-D").append("sa.init.defer").append("=dynamic");
        try {
            vm.loadAgent(agentPath, inputArguments.toString());
        }
        finally {
            vm.detach();
        }
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        SpecialAgent.premain(agentArgs, inst);
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        SpecialAgent.premain(agentArgs, inst, null, null);
    }

    public static void premain(String agentArgs, Instrumentation inst, File[] ruleFiles, IsoClassLoader isoClassLoader) {
        SpecialAgent.inst = inst;
        try {
            if (agentArgs != null) {
                AssembleUtil.absorbProperties(agentArgs);
            }
            SpecialAgent.init(ruleFiles, isoClassLoader);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Terminating initialization of SpecialAgent due to:", t);
        }
    }

    private static void init(File[] ruleFiles, IsoClassLoader isoClassLoader) throws IOException, ReflectiveOperationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initializing SpecialAgent\n");
        }
        AssembleUtil.loadProperties();
        BootLoaderAgent.premain(inst, null);
        AgentRule$.Access.load();
        SpecialAgent.load(SpecialAgent.instrumenter.manager, ruleFiles, isoClassLoader);
        long startupTime = (System.currentTimeMillis() - startTime) / 10L;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initialized SpecialAgent in " + (double)startupTime / 100.0 + "s\n");
        }
    }

    private static void load(Manager manager, File[] ruleFiles, IsoClassLoader isoClassLoader) throws IOException, ReflectiveOperationException {
        HashMap<String, String> nameToVersion;
        int count;
        boolean allExportersEnabled;
        boolean allIntegrationsEnabled;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SpecialAgent#load(" + manager.getClass().getSimpleName() + ") java.class.path:\n  " + System.getProperty("java.class.path").replace(File.pathSeparator, "\n  "));
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            String key = String.valueOf(property.getKey());
            String value = (String)properties.get(key);
            if (value != null && !value.equals(property.getValue())) {
                throw new IllegalStateException("System property " + key + " is specified twice with different values: \"" + value + "\" and \"" + property.getValue() + "\"");
            }
            properties.put(key, property.getValue() == null ? null : String.valueOf(property.getValue()));
        }
        final ArrayList<String> verbosePluginNames = new ArrayList<String>();
        final HashMap<String, Boolean> integrationRuleNameToEnable = new HashMap<String, Boolean>();
        final HashMap<String, Boolean> traceExporterNameToEnable = new HashMap<String, Boolean>();
        File[] classPaths = SpecialAgentUtil.parseConfiguration(properties, verbosePluginNames, integrationRuleNameToEnable, traceExporterNameToEnable);
        boolean bl = allIntegrationsEnabled = !integrationRuleNameToEnable.containsKey("*") || integrationRuleNameToEnable.remove("*") != false;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Integration Rules are " + (allIntegrationsEnabled ? "en" : "dis") + "abled");
        }
        boolean bl2 = allExportersEnabled = !traceExporterNameToEnable.containsKey("*") || traceExporterNameToEnable.remove("*") != false;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Trace Exporters are " + (allExportersEnabled ? "en" : "dis") + "abled");
        }
        Supplier<File> destDir = new Supplier<File>(){
            private File destDir;

            @Override
            public File get() {
                try {
                    return this.destDir == null ? (this.destDir = Files.createTempDirectory("opentracing-specialagent", new FileAttribute[0]).toFile()) : this.destDir;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        if (ruleFiles != null) {
            SpecialAgent.isoClassLoader = Objects.requireNonNull(isoClassLoader);
            for (File pluginFile : ruleFiles) {
                if (pluginManifestDirectory.containsKey(pluginFile)) continue;
                pluginManifestDirectory.put(pluginFile, PluginManifest.getPluginManifest(pluginFile));
            }
        } else {
            final ArrayList isoUrls = new ArrayList();
            SpecialAgentUtil.findJarResources("META-INF/iso/", destDir, new Predicate<File>(){

                @Override
                public boolean test(File file) {
                    try {
                        isoUrls.add(new URL("file", "", file.getAbsolutePath()));
                        return true;
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
            SpecialAgent.isoClassLoader = new IsoClassLoader(isoUrls.toArray(new URL[isoUrls.size()]), ClassLoader.getSystemClassLoader());
            Predicate<File> loadPluginPredicate = new Predicate<File>(){

                @Override
                public boolean test(File file) {
                    PluginManifest pluginManifest = PluginManifest.getPluginManifest(file);
                    boolean enablePlugin = true;
                    if (pluginManifest != null) {
                        Pattern namePattern;
                        boolean isIntegration = pluginManifest.type == PluginManifest.Type.INSTRUMENTATION;
                        enablePlugin = isIntegration ? allIntegrationsEnabled : allExportersEnabled;
                        HashMap pluginNameToEnable = isIntegration ? integrationRuleNameToEnable : traceExporterNameToEnable;
                        for (String string : verbosePluginNames) {
                            namePattern = AssembleUtil.convertToNameRegex(string);
                            if (!pluginManifest.name.equals(string) && !namePattern.matcher(pluginManifest.name).matches()) continue;
                            System.setProperty("sa." + (isIntegration ? "integration" : "exporter") + "." + pluginManifest.name + ".verbose", "true");
                            break;
                        }
                        for (Map.Entry entry : pluginNameToEnable.entrySet()) {
                            namePattern = AssembleUtil.convertToNameRegex((String)entry.getKey());
                            if (!pluginManifest.name.equals(entry.getKey()) && !namePattern.matcher(pluginManifest.name).matches()) continue;
                            enablePlugin = (Boolean)entry.getValue();
                            if (!logger.isLoggable(Level.FINER)) break;
                            logger.finer((isIntegration ? "Integration" : "Trace Exporter") + " " + pluginManifest.name + " is " + (enablePlugin ? "en" : "dis") + "abled");
                            break;
                        }
                    }
                    if (!enablePlugin) {
                        return false;
                    }
                    pluginManifestDirectory.put(file, pluginManifest);
                    return true;
                }
            };
            if (classPaths != null) {
                for (File classPath : classPaths) {
                    loadPluginPredicate.test(classPath);
                }
            }
            SpecialAgentUtil.findJarResources("META-INF/plugins/", destDir, loadPluginPredicate);
            if (pluginManifestDirectory.size() == 0) {
                logger.warning("No JARs were found under META-INF/plugins/, and ruleFiles == null");
            }
        }
        Enumeration<URL> instrumentationRules = manager.getResources();
        while (instrumentationRules.hasMoreElements()) {
            File pluginFile = AssembleUtil.getSourceLocation(instrumentationRules.nextElement(), manager.file);
            PluginManifest pluginManifest = PluginManifest.getPluginManifest(pluginFile);
            pluginManifestDirectory.put(pluginManifest.file, pluginManifest);
        }
        pluginManifestDirectory.sort();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Loading " + pluginManifestDirectory.size() + " rule paths:\n" + AssembleUtil.toIndentedString(pluginManifestDirectory.keySet()));
        }
        if ((count = SpecialAgent.loadDependencies(pluginsClassLoader = new PluginsClassLoader(pluginManifestDirectory.keySet()), nameToVersion = new HashMap<String, String>()) + SpecialAgent.loadDependencies(ClassLoader.getSystemClassLoader(), nameToVersion)) == 0) {
            logger.log(Level.SEVERE, "Could not find dependencies.tgf in any rule JARs");
        }
        Event[] events = SpecialAgentUtil.digestEventsProperty(System.getProperty("sa.log.events"));
        SpecialAgent.loadRules(manager, events);
    }

    private static int loadDependencies(ClassLoader classLoader, Map<String, String> nameToVersion) throws IOException {
        int count = 0;
        Enumeration<URL> enumeration = classLoader.getResources("dependencies.tgf");
        HashSet<String> urls = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            if (urls.contains(url.toString())) continue;
            urls.add(url.toString());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Found dependencies.tgf: <" + AssembleUtil.getNameId(url) + ">" + url);
            }
            File jarFile = AssembleUtil.getSourceLocation(url, "dependencies.tgf");
            String dependenciesTgf = new String(AssembleUtil.readBytes(url));
            String firstLine = dependenciesTgf.substring(0, dependenciesTgf.indexOf(10));
            String version = firstLine.substring(firstLine.lastIndexOf(58) + 1);
            PluginManifest pluginManifest = pluginManifestDirectory.get(jarFile);
            if (pluginManifest == null) {
                throw new IllegalStateException("Expected to find " + PluginManifest.class.getSimpleName() + " for file: " + jarFile + " in: " + pluginManifestDirectory.keySet());
            }
            String exists = nameToVersion.get(pluginManifest.name);
            if (exists != null && !exists.equals(version)) {
                throw new IllegalStateException("Illegal attempt to overwrite previously defined version for: " + pluginManifest.name);
            }
            nameToVersion.put(pluginManifest.name, version);
            Object[] dependencyFiles = MavenUtil.filterRuleURLs(pluginsClassLoader.getFiles(), dependenciesTgf, true, "compile");
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("  URLs from dependencies.tgf: " + AssembleUtil.toIndentedString(dependencyFiles));
            }
            if (dependencyFiles == null) {
                throw new UnsupportedOperationException("Unsupported dependencies.tgf encountered: " + url + "\nPlease file an issue on https://github.com/opentracing-contrib/java-specialagent/");
            }
            boolean foundReference = false;
            for (Object dependencyFile : dependencyFiles) {
                if (!pluginsClassLoader.containsPath((File)dependencyFile)) continue;
                foundReference = true;
                File[] registeredDependencyFiles = pluginFileToDependencies.get(dependencyFile);
                if (registeredDependencyFiles != null) {
                    if (registeredDependencyFiles == pluginFileToDependencies.get(jarFile)) continue;
                    throw new IllegalStateException("Dependencies already registered for " + dependencyFile + ". Are there multiple rule JARs with " + "dependencies.tgf" + " referencing the same rule JAR? Offending JAR: " + jarFile);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Registering dependencies for " + jarFile + " and " + dependencyFile + ":\n" + AssembleUtil.toIndentedString(dependencyFiles));
                }
                ++count;
                pluginFileToDependencies.put(jarFile, (File[])dependencyFiles);
            }
            if (foundReference) continue;
            throw new IllegalStateException("Could not find a rule JAR referenced in " + jarFile + "dependencies.tgf" + " from: \n" + AssembleUtil.toIndentedString(dependencyFiles));
        }
        return count;
    }

    private static void loadAdapter(List<String> tracerExcludedClasses, List<IntegrationRule> integraitonRules) {
        if (integraitonRules == null) {
            return;
        }
        try {
            for (IntegrationRule integraitonRule : integraitonRules) {
                Class<?> cls = isoClassLoader.loadClass(integraitonRule.getPluginManifest().adapterClassName);
                if (!adapterClasses.add(cls)) continue;
                Collections.addAll(tracerExcludedClasses, ((Adapter)cls.getConstructor(new Class[0]).newInstance(new Object[0])).loadTracer(isoClassLoader));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRules(final Manager manager, final Event[] events) {
        AttachMode attachMode = AttachMode.STATIC_DEFERRED;
        try {
            block21: {
                String initDeferProperty;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("\n<<<<<<<<<<<<<<<<<<<<< Loading AgentRule(s) >>>>>>>>>>>>>>>>>>>>\n");
                }
                if (pluginsClassLoader == null) {
                    throw new IllegalStateException("Attempt to load OpenTracing agent rules before allPluginsClassLoader initialized");
                }
                final ArrayList<String> tracerExcludedClasses = new ArrayList<String>();
                final ArrayList<IntegrationRule> integrationRules = new ArrayList<IntegrationRule>();
                HashMap<String, String> classNameToName = new HashMap<String, String>();
                AgentRule$.Access.configure(new Runnable(){

                    @Override
                    public void run() {
                        manager.loadRules(inst, false, integrationRules, tracerExcludedClasses.size() == 0 ? null : tracerExcludedClasses.toArray(new String[tracerExcludedClasses.size()]), events);
                    }
                }, classNameToName);
                int noDeferrers = manager.scanRules(inst, pluginsClassLoader, pluginManifestDirectory, integrationRules, classNameToName);
                SpecialAgent.loadAdapter(tracerExcludedClasses, integrationRules);
                if (tracerExcludedClasses.size() == 0) {
                    logger.warning("No adapter was loaded!");
                }
                if ((initDeferProperty = System.getProperty("sa.init.defer")) != null) {
                    attachMode = "dynamic".equals(initDeferProperty) ? AttachMode.DYNAMIC : ("false".equals(initDeferProperty) ? AttachMode.STATIC : AttachMode.STATIC_DEFERRED);
                }
                String displayString = attachMode == AttachMode.STATIC_DEFERRED ? "Enabled: true (default)   " : "    Enabled: false        ";
                logger.info(".==============================================================.");
                logger.info("|                    Static Deferred Attach                    |");
                logger.info("|                    " + displayString + "                |");
                if (attachMode == AttachMode.DYNAMIC) {
                    logger.info("|                    (using dynamic attach)                    |");
                }
                logger.info("|==============================================================|");
                if (attachMode == AttachMode.STATIC_DEFERRED) {
                    logger.info("|               To disable Static Deferred Attach,             |");
                    logger.info("|                 specify -Dsa.init.defer=false                |");
                    logger.info("|=============================================================='");
                }
                if (noDeferrers == 0) {
                    if (attachMode == AttachMode.STATIC_DEFERRED) {
                        logger.info("' 0 deferrers were detected, overriding to: -Dsa.init.defer=false");
                        attachMode = AttachMode.STATIC;
                        System.setProperty("sa.init.defer", "false");
                    } else {
                        logger.info("' 0 deferrers were detected");
                    }
                    break block21;
                }
                logger.info("' " + noDeferrers + " deferrers were detected:");
                for (IntegrationRule integrationRule : integrationRules) {
                    if (integrationRule.getDeferrers() == null) continue;
                    for (AgentRule deferrer : integrationRule.getDeferrers()) {
                        logger.info("  " + deferrer.getClass().getName());
                    }
                }
                if (attachMode != AttachMode.STATIC_DEFERRED) break block21;
                manager.loadRules(inst, true, integrationRules, tracerExcludedClasses.size() == 0 ? null : tracerExcludedClasses.toArray(new String[tracerExcludedClasses.size()]), events);
                return;
            }
            try {
                AgentRule$.Access.init();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to load OpenTracing agent rules", e);
            }
            return;
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                if (attachMode == AttachMode.STATIC_DEFERRED) {
                    logger.fine("\n>>>>>>>>>>>>> Loading of AgentRule(s) is Deferred <<<<<<<<<<<<<\n");
                } else {
                    logger.fine("\n>>>>>>>>>>>>>>>>>>>>> Loaded AgentRule(s) <<<<<<<<<<<<<<<<<<<<<\n");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean linkRule(PluginManifest pluginManifest, ClassLoader classLoader) {
        Object ruleClassLoaders;
        Object[] pluginDependencyFiles;
        Map<ClassLoader, Boolean> classLoaderToCompatibility = pluginManifest.getClassLoaderToCompatibility();
        Boolean compatible = classLoaderToCompatibility.get(classLoader);
        if (compatible != null && compatible.booleanValue()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("SpecialAgent.linkRule(\"" + pluginManifest.name + "\", " + AssembleUtil.getNameId(classLoader) + "): compatible = " + compatible + " [cached]");
            }
            return true;
        }
        File pluginFile = pluginManifest.file;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SpecialAgent.linkRule(\"" + pluginManifest.name + "\", " + AssembleUtil.getNameId(classLoader) + "): compatible = " + compatible + ", RulePath: " + pluginFile);
        }
        if ((pluginDependencyFiles = pluginFileToDependencies.get(pluginFile)) == null) {
            throw new IllegalStateException("No dependencies.tgf was registered for: " + pluginFile);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[" + pluginManifest.name + "] new " + RuleClassLoader.class.getSimpleName() + "([\n" + AssembleUtil.toIndentedString(pluginDependencyFiles) + "]\n, " + AssembleUtil.getNameId(classLoader) + ");");
        }
        RuleClassLoader ruleClassLoader = new RuleClassLoader(pluginManifest, isoClassLoader, classLoader, (File[])pluginDependencyFiles);
        compatible = ruleClassLoader.isCompatible(classLoader);
        classLoaderToCompatibility.put(classLoader, compatible);
        if (!compatible.booleanValue()) {
            try {
                ruleClassLoader.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "[" + pluginManifest.name + "] Failed to close " + RuleClassLoader.class.getSimpleName() + ": " + AssembleUtil.getNameId(ruleClassLoader), e);
            }
            return false;
        }
        if (classLoader == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + pluginManifest.name + "] Target class loader is: null (bootstrap)");
            }
            for (Object pluginDependencyFile : pluginDependencyFiles) {
                try {
                    File file = new File(((File)pluginDependencyFile).getPath());
                    inst.appendToBootstrapClassLoaderSearch(file.isFile() ? new JarFile(file) : SpecialAgentUtil.createTempJarFile(file));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "[" + pluginManifest.name + "] Failed to add path to bootstrap class loader: " + ((File)pluginDependencyFile).getPath(), e);
                }
            }
        } else if (classLoader == ClassLoader.getSystemClassLoader()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[" + pluginManifest.name + "] Target class loader is: " + AssembleUtil.getNameId(classLoader) + " (system)");
            }
            for (Object pluginDependencyFile : pluginDependencyFiles) {
                try {
                    inst.appendToSystemClassLoaderSearch(((File)pluginDependencyFile).isFile() ? new JarFile((File)pluginDependencyFile) : SpecialAgentUtil.createTempJarFile((File)pluginDependencyFile));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "[" + pluginManifest.name + "] Failed to add path to system class loader: " + pluginDependencyFile, e);
                }
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("[" + pluginManifest.name + "] Target class loader is: " + AssembleUtil.getNameId(classLoader));
        }
        if ((ruleClassLoaders = classLoaderToRuleClassLoader.get(classLoader)) == null) {
            ClassLoaderMap<List<RuleClassLoader>> classLoaderMap = classLoaderToRuleClassLoader;
            synchronized (classLoaderMap) {
                ruleClassLoaders = classLoaderToRuleClassLoader.get(classLoader);
                if (ruleClassLoaders == null) {
                    ruleClassLoaders = new IdentityList(new ArrayList());
                    classLoaderToRuleClassLoader.put(classLoader, (List<RuleClassLoader>)ruleClassLoaders);
                }
            }
        }
        StackTraceElement[] stackTraceElementArray = ruleClassLoaders;
        synchronized (ruleClassLoaders) {
            if (!ruleClassLoaders.contains(ruleClassLoader)) {
                ruleClassLoaders.add((RuleClassLoader)ruleClassLoader);
            }
            // ** MonitorExit[var8_11] (shouldn't be in output)
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                if (!DEFINE_CLASS.equals(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName())) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("[" + pluginManifest.name + "] Injection of integration classes deferred");
                }
                return true;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("[" + pluginManifest.name + "] Injection of integration classes called");
            }
            ruleClassLoader.inject(classLoader);
            return true;
        }
    }

    private static <R, T extends Throwable> R invoke(String name, ClassLoader targetLoader, QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, R, T> function) throws T {
        for (ClassLoader contextLoader = targetLoader; contextLoader != null; contextLoader = contextLoader.getParent()) {
            R r;
            List<RuleClassLoader> ruleClassLoaders = classLoaderToRuleClassLoader.get(contextLoader);
            if (ruleClassLoaders == null || (r = function.apply(targetLoader, name, ruleClassLoaders, contextLoader)) == null) continue;
            return r;
        }
        return null;
    }

    public static void inject(ClassLoader classLoader) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(">>>>>>>> inject(" + AssembleUtil.getNameId(classLoader) + ")");
        }
        SpecialAgent.invoke(null, classLoader, inject);
    }

    public static byte[] findClass(ClassLoader classLoader, String name) {
        return SpecialAgent.invoke(name, classLoader, findClass);
    }

    public static URL findResource(ClassLoader classLoader, String name) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(">>>>>>>> findResource(" + AssembleUtil.getNameId(classLoader) + ", \"" + name + "\")");
        }
        return SpecialAgent.invoke(name, classLoader, findResource);
    }

    public static Enumeration<URL> findResources(ClassLoader classLoader, String name) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(">>>>>>>> findResources(" + AssembleUtil.getNameId(classLoader) + ", \"" + name + "\")");
        }
        return SpecialAgent.invoke(name, classLoader, findResources);
    }

    static {
        instrumenter = Instrumenter.BYTEBUDDY;
        startTime = System.currentTimeMillis();
        SpecialAgentUtil.assertJavaAgentJarName();
        adapterClasses = new HashSet(1);
        inject = new QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, Boolean, RuntimeException>(){

            @Override
            public Boolean apply(ClassLoader targetLoader, String name, List<RuleClassLoader> ruleClassLoaders, ClassLoader contextLoader) {
                for (int i = 0; i < ruleClassLoaders.size(); ++i) {
                    RuleClassLoader ruleClassLoader = ruleClassLoaders.get(i);
                    ruleClassLoader.inject(contextLoader);
                }
                return Boolean.TRUE;
            }
        };
        findClass = new QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, byte[], RuntimeException>(){

            @Override
            public byte[] apply(ClassLoader targetLoader, String name, List<RuleClassLoader> ruleClassLoaders, ClassLoader contextLoader) {
                String resourceName = AssembleUtil.classNameToResource(name);
                for (int i = 0; i < ruleClassLoaders.size(); ++i) {
                    RuleClassLoader ruleClassLoader = ruleClassLoaders.get(i);
                    if (ruleClassLoader.isClosed(contextLoader)) {
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest(">>>>>>>> findClass(" + AssembleUtil.getNameId(targetLoader) + ", \"" + name + "\"): CLOSED");
                        continue;
                    }
                    URL resourceUrl = ruleClassLoader.getResource(resourceName);
                    if (resourceUrl == null) continue;
                    byte[] bytecode = AssembleUtil.readBytes(resourceUrl);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(">>>>>>>> findClass(" + AssembleUtil.getNameId(targetLoader) + ", \"" + name + "\"): BYTECODE " + (bytecode != null ? "!" : "=") + "= null");
                    }
                    return bytecode;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(">>>>>>>> findClass(" + AssembleUtil.getNameId(targetLoader) + ", \"" + name + "\"): Not found in " + ruleClassLoaders.size() + " RuleClassLoader(s)");
                }
                return null;
            }
        };
        findResource = new QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, URL, RuntimeException>(){

            @Override
            public URL apply(ClassLoader targetLoader, String name, List<RuleClassLoader> ruleClassLoaders, ClassLoader contextLoader) {
                for (int i = 0; i < ruleClassLoaders.size(); ++i) {
                    URL resource;
                    RuleClassLoader ruleClassLoader = ruleClassLoaders.get(i);
                    if (ruleClassLoader.isClosed(contextLoader) || (resource = ruleClassLoader.findResource(name)) == null) continue;
                    return resource;
                }
                return null;
            }
        };
        findResources = new QuadFunction<ClassLoader, String, List<RuleClassLoader>, ClassLoader, Enumeration<URL>, IOException>(){

            @Override
            public Enumeration<URL> apply(ClassLoader targetLoader, String name, List<RuleClassLoader> ruleClassLoaders, ClassLoader contextLoader) throws IOException {
                for (int i = 0; i < ruleClassLoaders.size(); ++i) {
                    Enumeration<URL> resources;
                    RuleClassLoader ruleClassLoader = ruleClassLoaders.get(i);
                    if (ruleClassLoader.isClosed(contextLoader) || !(resources = ruleClassLoader.findResources(name)).hasMoreElements()) continue;
                    return resources;
                }
                return null;
            }
        };
    }

    private static enum AttachMode {
        STATIC,
        DYNAMIC,
        STATIC_DEFERRED;

    }
}

