/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.BootLoaderAgent;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.RuleClassLoader;
import io.opentracing.contrib.specialagent.SpecialAgent;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.Enumeration;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class SpecialAgentAgent {
    public static final Logger logger = Logger.getLogger(SpecialAgentAgent.class);

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentBuilder.Identified.Narrowable builder = new AgentBuilder.Default().ignore(ElementMatchers.nameStartsWith("net.bytebuddy.").or(ElementMatchers.nameStartsWith("sun.reflect.")).or(ElementMatchers.isSynthetic()), ElementMatchers.any(), ElementMatchers.any()).disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(AgentBuilder.InitializationStrategy.NoOp.INSTANCE).with(AgentBuilder.TypeStrategy.Default.REDEFINE).type(ElementMatchers.is(SpecialAgent.class));
        builder.transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit(Advice.to(FindClass.class, (ClassFileLocator)BootLoaderAgent.cachedLocator).on(ElementMatchers.isStatic().and(ElementMatchers.named("findClass").and(ElementMatchers.returns(byte[].class).and(ElementMatchers.takesArguments(ClassLoader.class, String.class))))));
            }
        }).installOn(inst);
        builder.transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit(Advice.to(FindResource.class, (ClassFileLocator)BootLoaderAgent.cachedLocator).on(ElementMatchers.isStatic().and(ElementMatchers.named("findResource").and(ElementMatchers.returns(URL.class).and(ElementMatchers.takesArguments(ClassLoader.class, String.class))))));
            }
        }).installOn(inst);
        builder.transform(new AgentBuilder.Transformer(){

            @Override
            public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                return builder.visit(Advice.to(FindResources.class, (ClassFileLocator)BootLoaderAgent.cachedLocator).on(ElementMatchers.isStatic().and(ElementMatchers.named("findResources").and(ElementMatchers.returns(Enumeration.class).and(ElementMatchers.takesArguments(ClassLoader.class, String.class))))));
            }
        }).installOn(inst);
    }

    public static class FindResources {
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) ClassLoader classLoader, @Advice.Argument(value=1) String arg, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Enumeration<URL> returned) {
            try {
                String classpath = System.getProperty("java.class.path");
                int index = classpath.indexOf("/opentracing-api-");
                int start = classpath.lastIndexOf(File.pathSeparatorChar, index);
                int end = classpath.indexOf(File.pathSeparatorChar, index);
                classpath = classpath.substring(start + 1, end != -1 ? end : classpath.length());
                if (!classpath.endsWith(".jar") && !classpath.endsWith("/")) {
                    classpath = classpath + "/";
                }
                try (RuleClassLoader ruleClassLoader = new RuleClassLoader(null, null, null, new File(classpath));){
                    returned = ruleClassLoader.getResources(arg);
                    returned.hasMoreElements();
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("<<<<<<< Agent#findResources(" + (classLoader == null ? "null" : classLoader.getClass().getName() + "@" + Integer.toString(System.identityHashCode(classLoader), 16)) + "," + arg + "): " + returned);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "<><><><> AgentAgent.FindResources#exit", t);
            }
        }
    }

    public static class FindResource {
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) ClassLoader classLoader, @Advice.Argument(value=1) String arg, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) URL returned) {
            try {
                String classpath = System.getProperty("java.class.path");
                int index = classpath.indexOf("/opentracing-api-");
                int start = classpath.lastIndexOf(File.pathSeparatorChar, index);
                int end = classpath.indexOf(File.pathSeparatorChar, index);
                classpath = classpath.substring(start + 1, end != -1 ? end : classpath.length());
                if (!classpath.endsWith(".jar") && !classpath.endsWith("/")) {
                    classpath = classpath + "/";
                }
                try (RuleClassLoader ruleClassLoader = new RuleClassLoader(null, null, null, new File(classpath));){
                    returned = ruleClassLoader.findResource(arg);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("<<<<<<< Agent#findResource(" + (classLoader == null ? "null" : classLoader.getClass().getName() + "@" + Integer.toString(System.identityHashCode(classLoader), 16)) + "," + arg + "): " + returned);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "<><><><> AgentAgent.FindResource#exit", t);
            }
        }
    }

    public static class FindClass {
        @Advice.OnMethodExit
        public static void exit(@Advice.Argument(value=0) ClassLoader classLoader, @Advice.Argument(value=1) String arg, @Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) byte[] returned) {
            try {
                String classpath = System.getProperty("java.class.path");
                int index = classpath.indexOf("/opentracing-api-");
                int start = classpath.lastIndexOf(File.pathSeparatorChar, index);
                int end = classpath.indexOf(File.pathSeparatorChar, index);
                classpath = classpath.substring(start + 1, end != -1 ? end : classpath.length());
                if (!classpath.endsWith(".jar") && !classpath.endsWith("/")) {
                    classpath = classpath + "/";
                }
                try (RuleClassLoader ruleClassLoader = new RuleClassLoader(null, null, null, new File(classpath));){
                    URL resource = ruleClassLoader.findResource(AssembleUtil.classNameToResource(arg));
                    if (resource != null) {
                        returned = AssembleUtil.readBytes(resource);
                    }
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("<<<<<<< Agent#findClass(" + (classLoader == null ? "null" : classLoader.getClass().getName() + "@" + Integer.toString(System.identityHashCode(classLoader), 16)) + "," + arg + "): " + returned);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "<><><><> AgentAgent.FindClass#exit", t);
            }
        }
    }
}

