/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.Event;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.Predicate;
import io.opentracing.contrib.specialagent.SpecialAgent;
import io.opentracing.contrib.specialagent.Supplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class SpecialAgentUtil {
    private static final Logger logger = Logger.getLogger(SpecialAgentUtil.class);
    private static Set<File> deleteDirs;
    private static final Predicate<File> deletePredicate;
    private static final Event[] DEFAULT_EVENTS;

    static File[] parseConfiguration(Map<String, String> properties, List<String> verbosePluginNames, Map<String, Boolean> integrationRuleNameToEnable, Map<String, Boolean> traceExporterNameToEnable) {
        String[] deprecatedKeys = new String[]{"sa.instrumentation.plugin.include", "sa.instrumentation.plugin.", "sa.tracer.plugin."};
        String[] currentKeys = new String[]{"sa.classpath", "sa.integration.", "sa.exporter."};
        Object[] includedPlugins1 = SpecialAgentUtil.parseConfiguration(deprecatedKeys, currentKeys, properties, verbosePluginNames, integrationRuleNameToEnable, traceExporterNameToEnable);
        Object[] includedPlugins2 = SpecialAgentUtil.parseConfiguration(currentKeys, currentKeys, properties, verbosePluginNames, integrationRuleNameToEnable, traceExporterNameToEnable);
        if (includedPlugins1 == null) {
            return includedPlugins2;
        }
        if (includedPlugins2 != null) {
            throw new IllegalArgumentException("Conflicting \"sa.instrumentation.plugin.include\" (" + Arrays.toString(includedPlugins1) + ") and \"sa.classpath\" (" + Arrays.toString(includedPlugins2) + ") properties specified");
        }
        return includedPlugins1;
    }

    private static File[] parseConfiguration(String[] keys, String[] currentKeys, Map<String, String> properties, List<String> verbosePluginNames, Map<String, Boolean> integrationRuleNameToEnable, Map<String, Boolean> traceExporterNameToEnable) {
        File[] includedPlugins = null;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String key = property.getKey();
            String value = property.getValue();
            if (key.equals(keys[0])) {
                String[] includePaths = value.split(File.pathSeparator);
                includedPlugins = new File[includePaths.length];
                for (int i = 0; i < includePaths.length; ++i) {
                    includedPlugins[i] = new File(includePaths[i]);
                }
            } else if (key.startsWith(keys[1])) {
                int len = keys[1].length();
                if (key.indexOf(".verbose", len + 1) != -1) {
                    verbosePluginNames.add(key.substring(len, key.length() - 8));
                } else if (key.indexOf(".enable", len + 1) != -1) {
                    integrationRuleNameToEnable.put(key.substring(len, key.length() - 7), !"false".equals(value));
                } else {
                    if (key.indexOf(".disable", len + 1) == -1) continue;
                    integrationRuleNameToEnable.put(key.substring(len, key.length() - 8), "false".equals(value));
                }
            } else {
                if (!key.startsWith(keys[2])) continue;
                int len = keys[2].length();
                if (key.indexOf(".enable", len + 1) != -1) {
                    traceExporterNameToEnable.put(key.substring(len, key.length() - 7), !"false".equals(value));
                } else {
                    if (key.indexOf(".disable", len + 1) == -1) continue;
                    traceExporterNameToEnable.put(key.substring(len, key.length() - 8), "false".equals(value));
                }
            }
            if (keys == currentKeys) continue;
            logger.warning("Deprecated key (as of v1.7.0): \"" + keys[0] + "\" should be changed to \"" + currentKeys[0] + "\"");
        }
        return includedPlugins;
    }

    static JarFile createTempJarFile(File dir) throws IOException {
        final Path dirPath = dir.toPath();
        Path zipPath = Files.createTempFile("specialagent", ".jar", new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(zipPath.toFile());
             final JarOutputStream jos = new JarOutputStream(fos);){
            AssembleUtil.recurseDir(dir, new Predicate<File>(){

                @Override
                public boolean test(File t) {
                    if (t.isFile()) {
                        Path filePath = t.toPath();
                        String name = dirPath.relativize(filePath).toString();
                        try {
                            jos.putNextEntry(new ZipEntry(name));
                            jos.write(Files.readAllBytes(filePath));
                            jos.closeEntry();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    return true;
                }
            });
        }
        File file = zipPath.toFile();
        file.deleteOnExit();
        return new JarFile(file);
    }

    static StringBuilder getInputArguments() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = ManagementFactory.getRuntimeMXBean().getInputArguments().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(iterator.next());
            ++i;
        }
        return builder;
    }

    private static URL getJavaAgentJar(String arg) throws MalformedURLException {
        int argsIndex = arg.indexOf(".jar=");
        return new URL("file", null, argsIndex == -1 ? arg : arg.substring(0, argsIndex + 4));
    }

    private static URL getLocation(Class<?> cls) {
        CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            return codeSource.getLocation();
        }
        for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!arg.startsWith("-javaagent:")) continue;
            try {
                URL location = SpecialAgentUtil.getJavaAgentJar(arg.substring(11));
                return location;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        String sunJavaCommand = System.getProperty("sun.java.command");
        if (sunJavaCommand == null) {
            return null;
        }
        String[] args = sunJavaCommand.split("\\s+-");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("javaagent:")) continue;
            try {
                URL location = SpecialAgentUtil.getJavaAgentJar(arg.substring(10));
                return location;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    private static Manifest getManifest(URL location) throws IOException {
        try (JarInputStream in = new JarInputStream(location.openStream());){
            Manifest manifest = in.getManifest();
            return manifest;
        }
    }

    private static String getBootClassPathManifestEntry(URL location) throws IOException {
        Manifest manifest = SpecialAgentUtil.getManifest(location);
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getValue("Boot-Class-Path");
    }

    static void assertJavaAgentJarName() {
        try {
            String jarName;
            String bootClassPathManifestEntry;
            URL location = SpecialAgentUtil.getLocation(SpecialAgent.class);
            if (location != null && (bootClassPathManifestEntry = SpecialAgentUtil.getBootClassPathManifestEntry(location)) != null && !(jarName = AssembleUtil.getName(location.getPath())).equals(bootClassPathManifestEntry)) {
                throw new IllegalStateException("Name of -javaagent JAR, which is currently " + jarName + ", must be: " + bootClassPathManifestEntry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Set<String> getJavaClassPath() {
        return new LinkedHashSet<String>(Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator)));
    }

    static int getOccurrences(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    static void findJarResources(String path, Supplier<File> destDir, Predicate<File> callback) {
        try {
            Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(path);
            if (!resources.hasMoreElements()) {
                return;
            }
            HashSet<URL> visitedResources = new HashSet<URL>();
            File outDir = null;
            do {
                URL resource;
                if (visitedResources.contains(resource = resources.nextElement())) continue;
                visitedResources.add(resource);
                URLConnection connection = resource.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                if (outDir == null) {
                    outDir = destDir.get();
                }
                if (outDir == null) {
                    return;
                }
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                jarURLConnection.setUseCaches(false);
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    String jarEntry = jarEntries.nextElement().getName();
                    if (jarEntry.length() <= path.length() || !jarEntry.startsWith(path)) continue;
                    int slash = jarEntry.lastIndexOf(47);
                    String jarFileName = jarEntry.substring(slash + 1);
                    File subDir = new File(outDir, jarEntry.substring(0, slash));
                    subDir.mkdirs();
                    File file = new File(subDir, jarFileName);
                    if (!file.isDirectory() && !file.getName().endsWith(".jar")) continue;
                    URL jarUrl = new URL(resource, jarEntry.substring(path.length()));
                    Files.copy(jarUrl.openStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (callback.test(file)) continue;
                    file.delete();
                }
            } while (resources.hasMoreElements());
            if (outDir != null) {
                SpecialAgentUtil.deleteOnShutdown(outDir);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void deleteOnShutdown(File dir) {
        if (deleteDirs == null) {
            deleteDirs = new HashSet<File>();
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        }
        deleteDirs.add(dir);
    }

    static String getName(Class<?> cls) {
        return cls == Void.TYPE ? null : (cls.isArray() ? cls.getComponentType().getName() + "[]" : cls.getName());
    }

    static String[] getNames(Class<?>[] classes) {
        if (classes.length == 0) {
            return null;
        }
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = SpecialAgentUtil.getName(classes[i]);
        }
        return names;
    }

    static Event[] digestEventsProperty(String eventsProperty) {
        if (eventsProperty == null) {
            return DEFAULT_EVENTS;
        }
        Object[] parts = eventsProperty.split(",");
        Arrays.sort(parts);
        Event[] events = Event.values();
        int i = 0;
        int j = 0;
        while (i < events.length) {
            int comparison;
            int n = comparison = j < parts.length ? events[i].name().compareTo((String)parts[j]) : -1;
            if (comparison < 0) {
                events[i] = null;
                ++i;
                continue;
            }
            if (comparison > 0) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return events;
    }

    public static <T> Enumeration<T> enumeration(final T[] a) {
        return new Enumeration<T>(){
            private int i = -1;
            private final int len = a.length - 1;

            @Override
            public boolean hasMoreElements() {
                return this.i < this.len;
            }

            @Override
            public T nextElement() {
                return a[++this.i];
            }
        };
    }

    private SpecialAgentUtil() {
    }

    static {
        deletePredicate = new Predicate<File>(){

            @Override
            public boolean test(File t) {
                return t.delete();
            }
        };
        DEFAULT_EVENTS = new Event[5];
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            for (File deleteDir : deleteDirs) {
                AssembleUtil.recurseDir(deleteDir, deletePredicate);
            }
        }
    }
}

