/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.AgentRule$;
import io.opentracing.contrib.specialagent.DefaultAgentRule;
import io.opentracing.contrib.specialagent.ThreadLocalCounter;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class TracerExclusionAgent {
    public static final ThreadLocalCounter entryCounter = AgentRule$.Access.entryCounter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentBuilder premain(String[] traceExcludedClasses, AgentBuilder builder) {
        DefaultAgentRule.log("\n<<<<<<<<<<<<<<< Installing TracerExclusionAgent >>>>>>>>>>>>>>>>\n", null, DefaultAgentRule.DefaultLevel.FINE);
        if (traceExcludedClasses == null || traceExcludedClasses.length == 0) {
            return null;
        }
        try {
            AgentBuilder.Identified.Narrowable narrowable = builder.type(ElementMatchers.hasSuperType(ElementMatchers.named(traceExcludedClasses[0])));
            for (int i = 1; i < traceExcludedClasses.length; ++i) {
                narrowable.or(ElementMatchers.hasSuperType(ElementMatchers.named(traceExcludedClasses[i])));
            }
            AgentBuilder.Identified.Extendable extendable = narrowable.transform(new AgentBuilder.Transformer(){

                @Override
                public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
                    return builder.visit(Advice.to(TracerExclusionAgent.class).on(ElementMatchers.isPublic().and(ElementMatchers.any())));
                }
            });
            return extendable;
        }
        finally {
            DefaultAgentRule.log("\n>>>>>>>>>>>>>>>> Installed TracerExclusionAgent <<<<<<<<<<<<<<<<\n", null, DefaultAgentRule.DefaultLevel.FINE);
        }
    }

    @Advice.OnMethodEnter
    public static void enter() {
        entryCounter.set((Integer)entryCounter.get() + 1);
    }

    @Advice.OnMethodExit
    public static void exit() {
        entryCounter.set((Integer)entryCounter.get() - 1);
    }
}

