/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.propagation.BinaryExtract;
import io.opentracing.propagation.BinaryInject;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import io.opentracing.tag.Tag;
import io.opentracing.util.ThreadLocalScopeManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockTracer
implements Tracer {
    private final List<MockSpan> finishedSpans = new ArrayList<MockSpan>();
    private final Propagator propagator;
    private final ScopeManager scopeManager;
    private boolean isClosed;

    public MockTracer() {
        this(new ThreadLocalScopeManager(), Propagator.TEXT_MAP);
    }

    public MockTracer(ScopeManager scopeManager) {
        this(scopeManager, Propagator.TEXT_MAP);
    }

    public MockTracer(ScopeManager scopeManager, Propagator propagator) {
        this.scopeManager = scopeManager;
        this.propagator = propagator;
    }

    public MockTracer(Propagator propagator) {
        this(new ThreadLocalScopeManager(), propagator);
    }

    public synchronized void reset() {
        this.finishedSpans.clear();
    }

    public synchronized List<MockSpan> finishedSpans() {
        return new ArrayList<MockSpan>(this.finishedSpans);
    }

    protected void onSpanFinished(MockSpan mockSpan) {
    }

    @Override
    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    public SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        this.propagator.inject((MockSpan.MockContext)spanContext, format, carrier);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.propagator.extract(format, carrier);
    }

    @Override
    public Span activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public Scope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        this.finishedSpans.clear();
    }

    synchronized void appendFinishedSpan(MockSpan mockSpan) {
        if (this.isClosed) {
            return;
        }
        this.finishedSpans.add(mockSpan);
        this.onSpanFinished(mockSpan);
    }

    private SpanContext activeSpanContext() {
        Span span = this.activeSpan();
        if (span == null) {
            return null;
        }
        return span.context();
    }

    public final class SpanBuilder
    implements Tracer.SpanBuilder {
        private final String operationName;
        private long startMicros;
        private List<MockSpan.Reference> references = new ArrayList<MockSpan.Reference>();
        private boolean ignoringActiveSpan;
        private Map<String, Object> initialTags = new HashMap<String, Object>();

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public SpanBuilder asChildOf(SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        @Override
        public SpanBuilder asChildOf(Span parent) {
            if (parent == null) {
                return this;
            }
            return this.addReference("child_of", parent.context());
        }

        @Override
        public SpanBuilder ignoreActiveSpan() {
            this.ignoringActiveSpan = true;
            return this;
        }

        @Override
        public SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            if (referencedContext != null) {
                this.references.add(new MockSpan.Reference((MockSpan.MockContext)referencedContext, referenceType));
            }
            return this;
        }

        @Override
        public SpanBuilder withTag(String key, String value) {
            this.initialTags.put(key, value);
            return this;
        }

        @Override
        public SpanBuilder withTag(String key, boolean value) {
            this.initialTags.put(key, value);
            return this;
        }

        @Override
        public SpanBuilder withTag(String key, Number value) {
            this.initialTags.put(key, value);
            return this;
        }

        @Override
        public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
            this.initialTags.put(tag.getKey(), value);
            return this;
        }

        @Override
        public SpanBuilder withStartTimestamp(long microseconds) {
            this.startMicros = microseconds;
            return this;
        }

        @Override
        public Scope startActive(boolean finishOnClose) {
            return MockTracer.this.scopeManager().activate(this.startManual(), finishOnClose);
        }

        @Override
        public MockSpan start() {
            return this.startManual();
        }

        @Override
        public MockSpan startManual() {
            if (this.startMicros == 0L) {
                this.startMicros = MockSpan.nowMicros();
            }
            SpanContext activeSpanContext = MockTracer.this.activeSpanContext();
            if (this.references.isEmpty() && !this.ignoringActiveSpan && activeSpanContext != null) {
                this.references.add(new MockSpan.Reference((MockSpan.MockContext)activeSpanContext, "child_of"));
            }
            return new MockSpan(MockTracer.this, this.operationName, this.startMicros, this.initialTags, this.references);
        }
    }

    public static interface Propagator {
        public static final Propagator PRINTER = new Propagator(){

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                System.out.println("inject(" + ctx + ", " + format + ", " + carrier + ")");
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                System.out.println("extract(" + format + ", " + carrier + ")");
                return null;
            }
        };
        public static final Propagator BINARY = new Propagator(){
            static final int BUFFER_SIZE = 128;

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                if (!(carrier instanceof BinaryInject)) {
                    throw new IllegalArgumentException("Expected BinaryInject, received " + carrier.getClass());
                }
                BinaryInject binary = (BinaryInject)carrier;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ObjectOutputStream objStream = null;
                try {
                    objStream = new ObjectOutputStream(stream);
                    objStream.writeLong(ctx.spanId());
                    objStream.writeLong(ctx.traceId());
                    for (Map.Entry<String, String> entry : ctx.baggageItems()) {
                        objStream.writeUTF(entry.getKey());
                        objStream.writeUTF(entry.getValue());
                    }
                    objStream.flush();
                    byte[] buff = stream.toByteArray();
                    binary.injectionBuffer(buff.length).put(buff);
                }
                catch (IOException e) {
                    throw new RuntimeException("Corrupted state", e);
                }
                finally {
                    if (objStream != null) {
                        try {
                            objStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                if (!(carrier instanceof BinaryExtract)) {
                    throw new IllegalArgumentException("Expected BinaryExtract, received " + carrier.getClass());
                }
                Long traceId = null;
                Long spanId = null;
                HashMap<String, String> baggage = new HashMap<String, String>();
                BinaryExtract binary = (BinaryExtract)carrier;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ObjectInputStream objStream = null;
                try {
                    ByteBuffer extractBuff = binary.extractionBuffer();
                    byte[] buff = new byte[extractBuff.remaining()];
                    extractBuff.get(buff);
                    objStream = new ObjectInputStream(new ByteArrayInputStream(buff));
                    spanId = objStream.readLong();
                    traceId = objStream.readLong();
                    while (objStream.available() > 0) {
                        baggage.put(objStream.readUTF(), objStream.readUTF());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Corrupted state", e);
                }
                finally {
                    if (objStream != null) {
                        try {
                            objStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (traceId != null && spanId != null) {
                    return new MockSpan.MockContext(traceId, spanId, baggage);
                }
                return null;
            }
        };
        public static final Propagator TEXT_MAP = new Propagator(){
            public static final String SPAN_ID_KEY = "spanid";
            public static final String TRACE_ID_KEY = "traceid";
            public static final String BAGGAGE_KEY_PREFIX = "baggage-";

            @Override
            public <C> void inject(MockSpan.MockContext ctx, Format<C> format, C carrier) {
                TextMapInject textMap;
                if (carrier instanceof TextMapInject) {
                    textMap = (TextMapInject)carrier;
                    for (Map.Entry<String, String> entry : ctx.baggageItems()) {
                        textMap.put(BAGGAGE_KEY_PREFIX + entry.getKey(), entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                textMap.put(SPAN_ID_KEY, String.valueOf(ctx.spanId()));
                textMap.put(TRACE_ID_KEY, String.valueOf(ctx.traceId()));
            }

            @Override
            public <C> MockSpan.MockContext extract(Format<C> format, C carrier) {
                Long traceId = null;
                Long spanId = null;
                HashMap<String, String> baggage = new HashMap<String, String>();
                if (carrier instanceof TextMapExtract) {
                    TextMapExtract textMap = (TextMapExtract)carrier;
                    for (Map.Entry<String, String> entry : textMap) {
                        if (TRACE_ID_KEY.equals(entry.getKey())) {
                            traceId = Long.valueOf(entry.getValue());
                            continue;
                        }
                        if (SPAN_ID_KEY.equals(entry.getKey())) {
                            spanId = Long.valueOf(entry.getValue());
                            continue;
                        }
                        if (!entry.getKey().startsWith(BAGGAGE_KEY_PREFIX)) continue;
                        String key = entry.getKey().substring(BAGGAGE_KEY_PREFIX.length());
                        baggage.put(key, entry.getValue());
                    }
                } else {
                    throw new IllegalArgumentException("Unknown carrier");
                }
                if (traceId != null && spanId != null) {
                    return new MockSpan.MockContext(traceId, spanId, baggage);
                }
                return null;
            }
        };

        public <C> void inject(MockSpan.MockContext var1, Format<C> var2, C var3);

        public <C> MockSpan.MockContext extract(Format<C> var1, C var2);
    }
}

