/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.mock.MockSpan;
import io.opentracing.mock.ProxyMockSpanContext;
import io.opentracing.mock.ProxyMockTracer;
import java.util.Map;
import java.util.Objects;

class ProxyMockScopeManager
implements ScopeManager {
    final ProxyMockTracer tracer;
    final ScopeManager mockScopeManager;
    final ScopeManager realScopeManager;

    ProxyMockScopeManager(ProxyMockTracer tracer, ScopeManager mockScopeManager, ScopeManager realScopeManager) {
        this.tracer = Objects.requireNonNull(tracer);
        this.mockScopeManager = Objects.requireNonNull(mockScopeManager);
        this.realScopeManager = Objects.requireNonNull(realScopeManager);
    }

    @Override
    public Scope activate(Span span) {
        if (!(span instanceof ProxyMockScope.ProxyMockSpan)) {
            throw new IllegalStateException();
        }
        ProxyMockScope.ProxyMockSpan proxyMockSpan = (ProxyMockScope.ProxyMockSpan)span;
        Scope mockScope = this.mockScopeManager.activate(proxyMockSpan.mockSpan);
        Scope realScope = this.realScopeManager.activate(proxyMockSpan.realSpan);
        return mockScope == null ? null : new ProxyMockScope(this.tracer, mockScope, realScope);
    }

    @Override
    @Deprecated
    public ProxyMockScope active() {
        Scope mockScope = this.mockScopeManager.active();
        Scope realScope = this.realScopeManager.active();
        return mockScope == null ? null : new ProxyMockScope(this.tracer, mockScope, realScope);
    }

    @Override
    public ProxyMockScope.ProxyMockSpan activeSpan() {
        Span mockSpan = this.mockScopeManager.activeSpan();
        Span realSpan = this.realScopeManager.activeSpan();
        return mockSpan == null ? null : new ProxyMockScope.ProxyMockSpan(this.tracer, (MockSpan)mockSpan, realSpan);
    }

    @Override
    @Deprecated
    public ProxyMockScope activate(Span span, boolean finishSpanOnClose) {
        if (!(span instanceof ProxyMockScope.ProxyMockSpan)) {
            throw new IllegalStateException();
        }
        ProxyMockScope.ProxyMockSpan proxyMockSpan = (ProxyMockScope.ProxyMockSpan)span;
        Scope mockScope = this.mockScopeManager.activate(proxyMockSpan.mockSpan, finishSpanOnClose);
        Scope realScope = this.realScopeManager.activate(proxyMockSpan.realSpan, finishSpanOnClose);
        return mockScope == null ? null : new ProxyMockScope(this.tracer, mockScope, realScope);
    }

    static class ProxyMockScope
    implements Scope {
        final ProxyMockTracer tracer;
        final Scope mockScope;
        final Scope realScope;
        private ProxyMockSpan span;

        ProxyMockScope(ProxyMockTracer tracer, Scope mockScope, Scope realScope) {
            this.tracer = Objects.requireNonNull(tracer);
            this.mockScope = Objects.requireNonNull(mockScope);
            this.realScope = Objects.requireNonNull(realScope);
        }

        @Override
        public void close() {
            this.mockScope.close();
            this.realScope.close();
        }

        @Override
        @Deprecated
        public ProxyMockSpan span() {
            Span realSpan;
            Span mockSpan = this.mockScope.span();
            Span span = realSpan = mockSpan == null ? null : Objects.requireNonNull(this.realScope.span());
            if (this.span == null || this.span.mockSpan != mockSpan) {
                this.span = new ProxyMockSpan(this.tracer, (MockSpan)mockSpan, realSpan);
            } else if (this.span.realSpan != realSpan) {
                this.span.realSpan = realSpan;
            }
            return this.span;
        }

        static class ProxyMockSpan
        extends MockSpan {
            private final Span mockSpan;
            private Span realSpan;

            ProxyMockSpan(ProxyMockTracer tracer, MockSpan mockSpan, Span realSpan) {
                super(tracer, mockSpan.operationName(), mockSpan.startMicros(), mockSpan.tags, mockSpan.references);
                this.mockSpan = mockSpan;
                this.realSpan = realSpan;
            }

            @Override
            public ProxyMockSpanContext context() {
                MockSpan.MockContext mockSpanContext = super.context();
                SpanContext realSpanContext = this.realSpan.context();
                return new ProxyMockSpanContext(mockSpanContext, realSpanContext);
            }

            @Override
            public ProxyMockSpan setTag(String key, String value) {
                super.setTag(key, value);
                this.realSpan.setTag(key, value);
                return this;
            }

            @Override
            public ProxyMockSpan setTag(String key, boolean value) {
                super.setTag(key, value);
                this.realSpan.setTag(key, value);
                return this;
            }

            @Override
            public ProxyMockSpan setTag(String key, Number value) {
                super.setTag(key, value);
                this.realSpan.setTag(key, value);
                return this;
            }

            @Override
            public ProxyMockSpan log(Map<String, ?> fields) {
                super.log(fields);
                this.realSpan.log(fields);
                return this;
            }

            @Override
            public ProxyMockSpan log(long timestampMicroseconds, Map<String, ?> fields) {
                super.log(timestampMicroseconds, (Map)fields);
                this.realSpan.log(timestampMicroseconds, fields);
                return this;
            }

            @Override
            public ProxyMockSpan log(String event) {
                super.log(event);
                this.realSpan.log(event);
                return this;
            }

            @Override
            public ProxyMockSpan log(long timestampMicroseconds, String event) {
                super.log(timestampMicroseconds, event);
                this.realSpan.log(timestampMicroseconds, event);
                return this;
            }

            @Override
            public ProxyMockSpan setBaggageItem(String key, String value) {
                super.setBaggageItem(key, value);
                this.realSpan.setBaggageItem(key, value);
                return this;
            }

            @Override
            public String getBaggageItem(String key) {
                String mockBaggageItem = super.getBaggageItem(key);
                String realBaggageItem = this.realSpan.getBaggageItem(key);
                if (mockBaggageItem != null ? !mockBaggageItem.equals(realBaggageItem) : realBaggageItem != null) {
                    throw new IllegalStateException();
                }
                return mockBaggageItem;
            }

            @Override
            public ProxyMockSpan setOperationName(String operationName) {
                super.setOperationName(operationName);
                this.realSpan.setOperationName(operationName);
                return this;
            }

            @Override
            public void finish() {
                super.finish(ProxyMockSpan.nowMicros());
                this.realSpan.finish();
            }

            @Override
            public void finish(long finishMicros) {
                super.finish(finishMicros);
                this.realSpan.finish(finishMicros);
            }
        }
    }
}

