/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.mock;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.mock.MockSpan;
import io.opentracing.mock.MockTracer;
import io.opentracing.mock.ProxyMockScopeManager;
import io.opentracing.mock.ProxyMockSpanContext;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.propagation.Format;
import io.opentracing.util.ThreadLocalScopeManager;

public class ProxyMockTracer
extends MockTracer {
    final Tracer realTracer;
    private ProxyMockScopeManager scopeManager;

    public ProxyMockTracer(MockTracer mockTracer, Tracer tracer) {
        super(mockTracer.scopeManager(), mockTracer.propagator);
        this.realTracer = tracer;
        if (mockTracer == tracer) {
            throw new IllegalArgumentException(ProxyMockTracer.class.getSimpleName() + " cannot proxy to itself");
        }
    }

    public ProxyMockTracer(Tracer tracer) {
        super(new ThreadLocalScopeManager(), MockTracer.Propagator.TEXT_MAP);
        this.realTracer = tracer;
    }

    public ProxyMockTracer(Tracer tracer, ScopeManager scopeManager) {
        super(scopeManager, MockTracer.Propagator.TEXT_MAP);
        this.realTracer = tracer;
    }

    public ProxyMockTracer(Tracer tracer, ScopeManager scopeManager, MockTracer.Propagator propagator) {
        super(scopeManager, propagator);
        this.realTracer = tracer;
    }

    public ProxyMockTracer(Tracer tracer, MockTracer.Propagator propagator) {
        super(NoopScopeManager.INSTANCE, propagator);
        this.realTracer = tracer;
    }

    @Override
    public ProxyMockScopeManager scopeManager() {
        ScopeManager mockScopeManager = super.scopeManager();
        ScopeManager realScopeManager = this.realTracer.scopeManager();
        if (this.scopeManager == null || this.scopeManager.mockScopeManager != mockScopeManager || this.scopeManager.realScopeManager != realScopeManager) {
            this.scopeManager = new ProxyMockScopeManager(this, mockScopeManager, realScopeManager);
        }
        return this.scopeManager;
    }

    @Override
    public ProxyMockSpanBuilder buildSpan(String operationName) {
        Tracer.SpanBuilder realSpanBuilder = this.realTracer.buildSpan(operationName);
        return new ProxyMockSpanBuilder(operationName, realSpanBuilder);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        super.inject(spanContext, format, carrier);
        this.realTracer.inject(((ProxyMockSpanContext)spanContext).realSpanContext, format, carrier);
    }

    @Override
    public <C> ProxyMockSpanContext extract(Format<C> format, C carrier) {
        SpanContext mockSpanContext = super.extract(format, carrier);
        SpanContext realSpanContext = this.realTracer.extract(format, carrier);
        return mockSpanContext == null ? null : new ProxyMockSpanContext((MockSpan.MockContext)mockSpanContext, realSpanContext);
    }

    @Override
    public Span activeSpan() {
        Span mockSpan = super.activeSpan();
        Span realSpan = this.realTracer.activeSpan();
        return mockSpan == null ? null : new ProxyMockScopeManager.ProxyMockScope.ProxyMockSpan(this, (MockSpan)mockSpan, realSpan);
    }

    class ProxyMockSpanBuilder
    extends MockTracer.SpanBuilder {
        final Tracer.SpanBuilder realSpanBuilder;

        public ProxyMockSpanBuilder(String operationName, Tracer.SpanBuilder realSpanBuilder) {
            super(operationName);
            this.realSpanBuilder = realSpanBuilder;
        }

        @Override
        public ProxyMockSpanBuilder asChildOf(SpanContext parent) {
            super.asChildOf(parent);
            this.realSpanBuilder.asChildOf(parent);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder asChildOf(Span parent) {
            super.asChildOf(parent);
            this.realSpanBuilder.asChildOf(parent);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder addReference(String referenceType, SpanContext referencedContext) {
            super.addReference(referenceType, referencedContext);
            this.realSpanBuilder.addReference(referenceType, referencedContext);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder ignoreActiveSpan() {
            super.ignoreActiveSpan();
            this.realSpanBuilder.ignoreActiveSpan();
            return this;
        }

        @Override
        public ProxyMockSpanBuilder withTag(String key, String value) {
            super.withTag(key, value);
            this.realSpanBuilder.withTag(key, value);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder withTag(String key, boolean value) {
            super.withTag(key, value);
            this.realSpanBuilder.withTag(key, value);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder withTag(String key, Number value) {
            super.withTag(key, value);
            this.realSpanBuilder.withTag(key, value);
            return this;
        }

        @Override
        public ProxyMockSpanBuilder withStartTimestamp(long microseconds) {
            super.withStartTimestamp(microseconds);
            this.realSpanBuilder.withStartTimestamp(microseconds);
            return this;
        }

        @Override
        @Deprecated
        public ProxyMockScopeManager.ProxyMockScope startActive(boolean finishSpanOnClose) {
            Scope mockScope = super.startActive(finishSpanOnClose);
            Scope realScope = this.realSpanBuilder.startActive(finishSpanOnClose);
            return new ProxyMockScopeManager.ProxyMockScope(ProxyMockTracer.this, mockScope, realScope);
        }

        @Override
        @Deprecated
        public ProxyMockScopeManager.ProxyMockScope.ProxyMockSpan startManual() {
            MockSpan mockSpan = super.startManual();
            Span realSpan = this.realSpanBuilder.startManual();
            return new ProxyMockScopeManager.ProxyMockScope.ProxyMockSpan(ProxyMockTracer.this, mockSpan, realSpan);
        }

        @Override
        public ProxyMockScopeManager.ProxyMockScope.ProxyMockSpan start() {
            MockSpan mockSpan = super.start();
            Span realSpan = this.realSpanBuilder.start();
            return new ProxyMockScopeManager.ProxyMockScope.ProxyMockSpan(ProxyMockTracer.this, mockSpan, realSpan);
        }
    }
}

