/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.specialagent;

import io.opentracing.contrib.specialagent.Adapter;
import io.opentracing.contrib.specialagent.AgentRuleUtil;
import io.opentracing.contrib.specialagent.AssembleUtil;
import io.opentracing.contrib.specialagent.Level;
import io.opentracing.contrib.specialagent.Logger;
import io.opentracing.contrib.specialagent.PluginManifest;
import io.opentracing.contrib.specialagent.ThreadLocalCounter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;

public abstract class AgentRule {
    private static boolean initialized;
    private static final InheritableThreadLocal<Boolean> isThreadInstrumentable;
    private static final Logger logger;
    private static final ThreadLocalCounter entryCounter;
    private static final ThreadLocal<String> currentAgentRuleClass;
    private static Map<String, String> classNameToName;
    private final String className = this.getClass().getName();
    private PluginManifest pluginManifest;
    private static Map<TypeDescription, PluginManifest> typeDescriptionToPluginManifest;

    public static String getCurrentPluginName() {
        return classNameToName.get(currentAgentRuleClass.get());
    }

    public static boolean isVerbose(String className) {
        boolean integrationsVerbose = AssembleUtil.isSystemProperty((String)"sa.integration.*.verbose", (String)"sa.instrumentation.plugin.*.verbose");
        if (integrationsVerbose) {
            return integrationsVerbose;
        }
        String integrationName = classNameToName.get(className);
        if (integrationName == null) {
            throw new IllegalStateException("Plugin name must not be null");
        }
        return AssembleUtil.isSystemProperty((String)("sa.integration." + integrationName + ".verbose"), (String)("sa.instrumentation.plugin." + integrationName + ".verbose"));
    }

    public final Advice.WithCustomMapping advice(TypeDescription typeDescription) {
        PluginManifest pluginManifest = typeDescriptionToPluginManifest.get(typeDescription);
        if (pluginManifest != null && pluginManifest != this.pluginManifest) {
            logger.severe("<><><><> Multiple integrations registered for: " + typeDescription);
        } else {
            typeDescriptionToPluginManifest.put(typeDescription, this.pluginManifest);
        }
        return Advice.withCustomMapping().bind(ClassName.class, (Object)this.className);
    }

    public static boolean isAllowed(String className, String origin) {
        boolean allowed;
        boolean bl = allowed = initialized && (Integer)entryCounter.get() == 0 && (Boolean)isThreadInstrumentable.get() != false;
        if (allowed) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("-------> Intercept [" + className.substring(className.lastIndexOf(46) + 1) + "@" + Thread.currentThread().getName() + "]: " + origin);
            }
            currentAgentRuleClass.set(className);
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("-------> Intercept [" + className.substring(className.lastIndexOf(46) + 1) + "@" + Thread.currentThread().getName() + "] DROP: " + origin);
        }
        return allowed;
    }

    public static PluginManifest getPluginManifest(TypeDescription typeDescription) {
        return typeDescriptionToPluginManifest.get(typeDescription);
    }

    public boolean isDeferrable(Instrumentation inst) {
        return false;
    }

    public AgentBuilder[] buildAgentUnchained(AgentBuilder builder) {
        return null;
    }

    public AgentBuilder buildAgentChainedLocal1(AgentBuilder builder) {
        return null;
    }

    public AgentBuilder buildAgentChainedLocal2(AgentBuilder builder) {
        return null;
    }

    public AgentBuilder buildAgentChainedGlobal1(AgentBuilder builder) {
        return null;
    }

    public AgentBuilder buildAgentChainedGlobal2(AgentBuilder builder) {
        return null;
    }

    static /* synthetic */ InheritableThreadLocal access$000() {
        return isThreadInstrumentable;
    }

    static /* synthetic */ Map access$102(Map x0) {
        classNameToName = x0;
        return classNameToName;
    }

    static /* synthetic */ boolean access$200() {
        return initialized;
    }

    static /* synthetic */ boolean access$202(boolean x0) {
        initialized = x0;
        return initialized;
    }

    static /* synthetic */ ThreadLocalCounter access$400() {
        return entryCounter;
    }

    static /* synthetic */ PluginManifest access$502(AgentRule x0, PluginManifest x1) {
        x0.pluginManifest = x1;
        return x0.pluginManifest;
    }

    static {
        isThreadInstrumentable = new InheritableThreadLocal<Boolean>(){

            @Override
            protected Boolean childValue(Boolean parentValue) {
                if (parentValue == null) {
                    logger.warning("Unknown instrumentable state for parent of thread: " + Thread.currentThread().getName());
                    parentValue = Boolean.TRUE;
                }
                if (!parentValue.booleanValue() || Adapter.tracerClassLoader == null) {
                    return parentValue;
                }
                return !AgentRuleUtil.isFromClassLoader(AgentRuleUtil.getExecutionStack(), Adapter.tracerClassLoader);
            }

            @Override
            public Boolean get() {
                Boolean state = (Boolean)super.get();
                if (state == null) {
                    logger.warning("Unknown instrumentable state for thread: " + Thread.currentThread().getName());
                    state = Boolean.TRUE;
                    this.set(state);
                }
                return state;
            }
        };
        logger = Logger.getLogger(AgentRule.class);
        entryCounter = new ThreadLocalCounter();
        currentAgentRuleClass = new ThreadLocal();
        typeDescriptionToPluginManifest = new HashMap<TypeDescription, PluginManifest>();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClassName {
    }
}

