/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import io.phasetwo.keycloak.magic.MagicLink;
import io.phasetwo.keycloak.magic.auth.token.MagicLinkActionToken;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.UsernamePasswordForm;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.UserModel;

public class MagicLinkAuthenticator
extends UsernamePasswordForm {
    private static final Logger log = Logger.getLogger(MagicLinkAuthenticator.class);
    static final String CREATE_NONEXISTENT_USER_CONFIG_PROPERTY = "ext-magic-create-nonexistent-user";
    static final String UPDATE_PROFILE_ACTION_CONFIG_PROPERTY = "ext-magic-update-profile-action";
    static final String UPDATE_PASSWORD_ACTION_CONFIG_PROPERTY = "ext-magic-update-password-action";
    static final String ACTION_TOKEN_PERSISTENT_CONFIG_PROPERTY = "ext-magic-allow-token-reuse";

    public void authenticate(AuthenticationFlowContext context) {
        log.info((Object)"MagicLinkAuthenticator.authenticate");
        String attemptedUsername = this.getAttemptedUsername(context);
        if (attemptedUsername == null) {
            super.authenticate(context);
        } else {
            log.infof("Found attempted username %s from previous authenticator, skipping login form", (Object)attemptedUsername);
            this.action(context);
        }
    }

    public void action(AuthenticationFlowContext context) {
        log.info((Object)"MagicLinkAuthenticator.action");
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String email = MagicLinkAuthenticator.trimToNull((String)formData.getFirst((Object)"username"));
        if (email == null) {
            email = this.getAttemptedUsername(context);
        }
        log.infof("email in action is %s", (Object)email);
        if (email == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        String clientId = context.getSession().getContext().getClient().getClientId();
        EventBuilder event = context.newEvent();
        UserModel user = MagicLink.getOrCreate(context.getSession(), context.getRealm(), email, this.isForceCreate(context, false), this.isUpdateProfile(context, false), this.isUpdatePassword(context, false), MagicLink.registerEvent(event));
        log.infof("user is %s %s", (Object)user.getEmail(), (Object)user.isEnabled());
        if (user == null || MagicLinkAuthenticator.trimToNull(user.getEmail()) == null || !MagicLinkAuthenticator.isValidEmail(user.getEmail())) {
            context.getEvent().event(EventType.LOGIN_ERROR).error("invalid_email");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return;
        }
        if (!this.enabledUser(context, user)) {
            return;
        }
        MagicLinkActionToken token = MagicLink.createActionToken(user, clientId, OptionalInt.empty(), this.rememberMe(context), context.getAuthenticationSession(), this.isActionTokenPersistent(context, true));
        String link = MagicLink.linkFromActionToken(context.getSession(), context.getRealm(), token);
        boolean sent = MagicLink.sendMagicLinkEmail(context.getSession(), user, link);
        log.infof("sent email to %s? %b. Link? %s", (Object)user.getEmail(), (Object)sent, (Object)link);
        context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", email);
        context.challenge(context.form().createForm("view-email.ftl"));
    }

    private boolean rememberMe(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String rememberMe = (String)formData.getFirst((Object)"rememberMe");
        return context.getRealm().isRememberMe() && rememberMe != null && rememberMe.equalsIgnoreCase("on");
    }

    private boolean isForceCreate(AuthenticationFlowContext context, boolean defaultValue) {
        return this.is(context, CREATE_NONEXISTENT_USER_CONFIG_PROPERTY, defaultValue);
    }

    private boolean isUpdateProfile(AuthenticationFlowContext context, boolean defaultValue) {
        return this.is(context, UPDATE_PROFILE_ACTION_CONFIG_PROPERTY, defaultValue);
    }

    private boolean isUpdatePassword(AuthenticationFlowContext context, boolean defaultValue) {
        return this.is(context, UPDATE_PASSWORD_ACTION_CONFIG_PROPERTY, defaultValue);
    }

    private boolean isActionTokenPersistent(AuthenticationFlowContext context, boolean defaultValue) {
        return this.is(context, ACTION_TOKEN_PERSISTENT_CONFIG_PROPERTY, defaultValue);
    }

    private boolean is(AuthenticationFlowContext context, String propName, boolean defaultValue) {
        AuthenticatorConfigModel authenticatorConfig = context.getAuthenticatorConfig();
        if (authenticatorConfig == null) {
            return defaultValue;
        }
        Map config = authenticatorConfig.getConfig();
        if (config == null) {
            return defaultValue;
        }
        String v = (String)config.get(propName);
        if (v == null || "".equals(v)) {
            return defaultValue;
        }
        return v.trim().toLowerCase().equals("true");
    }

    private static boolean isValidEmail(String email) {
        try {
            InternetAddress a = new InternetAddress(email);
            a.validate();
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    private String getAttemptedUsername(AuthenticationFlowContext context) {
        if (context.getUser() != null && context.getUser().getEmail() != null) {
            return context.getUser().getEmail();
        }
        String username = MagicLinkAuthenticator.trimToNull(context.getAuthenticationSession().getAuthNote("ATTEMPTED_USERNAME"));
        if (username != null) {
            if (MagicLinkAuthenticator.isValidEmail(username)) {
                return username;
            }
            UserModel user = context.getSession().users().getUserByUsername(context.getRealm(), username);
            if (user != null && user.getEmail() != null) {
                return user.getEmail();
            }
        }
        return null;
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        if ("".equalsIgnoreCase(trimmed)) {
            trimmed = null;
        }
        return trimmed;
    }

    protected boolean validateForm(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        log.info((Object)"validateForm");
        return this.validateUser(context, formData);
    }

    protected Response challenge(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        log.info((Object)"challenge");
        LoginFormsProvider forms = context.form();
        if (!formData.isEmpty()) {
            forms.setFormData(formData);
        }
        return forms.createLoginUsername();
    }

    protected Response createLoginForm(LoginFormsProvider form) {
        log.info((Object)"createLoginForm");
        return form.createLoginUsername();
    }

    protected String getDefaultChallengeMessage(AuthenticationFlowContext context) {
        log.info((Object)"getDefaultChallengeMessage");
        return context.getRealm().isLoginWithEmailAllowed() ? "invalidUsernameOrEmailMessage" : "invalidUsernameMessage";
    }
}

