/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.magic.MagicLink;
import io.phasetwo.keycloak.magic.auth.MagicLinkAuthenticator;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class MagicLinkAuthenticatorFactory
implements AuthenticatorFactory {
    private static final Logger log = Logger.getLogger(MagicLinkAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-magic-form";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};

    public Authenticator create(KeycloakSession session) {
        return new MagicLinkAuthenticator();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getReferenceCategory() {
        return "alternate-auth";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getDisplayType() {
        return "Magic Link";
    }

    public String getHelpText() {
        return "Sign in with a magic link that will be sent to your email.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty createUser = new ProviderConfigProperty();
        createUser.setType("boolean");
        createUser.setName("ext-magic-create-nonexistent-user");
        createUser.setLabel("Force create user");
        createUser.setHelpText("Creates a new user when an email is provided that does not match an existing user.");
        createUser.setDefaultValue((Object)true);
        ProviderConfigProperty updateProfile = new ProviderConfigProperty();
        updateProfile.setType("boolean");
        updateProfile.setName("ext-magic-update-profile-action");
        updateProfile.setLabel("Update profile on create");
        updateProfile.setHelpText("Add an UPDATE_PROFILE required action if the user was created.");
        updateProfile.setDefaultValue((Object)false);
        ProviderConfigProperty updatePassword = new ProviderConfigProperty();
        updatePassword.setType("boolean");
        updatePassword.setName("ext-magic-update-password-action");
        updatePassword.setLabel("Update password on create");
        updatePassword.setHelpText("Add an UPDATE_PASSWORD required action if the user was created.");
        updatePassword.setDefaultValue((Object)false);
        ProviderConfigProperty actionTokenPersistent = new ProviderConfigProperty();
        actionTokenPersistent.setType("boolean");
        actionTokenPersistent.setName("ext-magic-allow-token-reuse");
        actionTokenPersistent.setLabel("Allow magic link to be reusable");
        actionTokenPersistent.setHelpText("Toggle whether magic link should be persistent until expired.");
        actionTokenPersistent.setDefaultValue((Object)true);
        return Arrays.asList(createUser, updateProfile, updatePassword, actionTokenPersistent);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(ev -> {
            if (ev instanceof RealmModel.RealmPostCreateEvent) {
                MagicLink.realmPostCreate(factory, (RealmModel.RealmPostCreateEvent)ev);
            }
        });
    }

    public void close() {
    }
}

