/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth.token;

import io.phasetwo.keycloak.magic.auth.model.MagicLinkContinuationBean;
import io.phasetwo.keycloak.magic.auth.token.MagicLinkContinuationActionToken;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MagicLinkContinuationLinkActionTokenHandler
extends AbstractActionTokenHandler<MagicLinkContinuationActionToken> {
    private static final Logger log = Logger.getLogger(MagicLinkContinuationLinkActionTokenHandler.class);

    public MagicLinkContinuationLinkActionTokenHandler() {
        super("magic-link-continuation", MagicLinkContinuationActionToken.class, "invalidRequestMessage", EventType.EXECUTE_ACTION_TOKEN, "invalid_request");
    }

    public Response handleToken(MagicLinkContinuationActionToken token, ActionTokenContext<MagicLinkContinuationActionToken> tokenContext) {
        AuthenticationSessionModel authenticationFlowSession;
        log.infof("HandleToken for iss:%s, user:%s", (Object)token.getIssuedFor(), (Object)token.getUserId());
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        ClientModel client = authSession.getClient();
        user.setEmailVerified(true);
        KeycloakSession session = tokenContext.getSession();
        AuthenticationSessionProvider provider = session.authenticationSessions();
        RootAuthenticationSessionModel rootAuthenticationSession = provider.getRootAuthenticationSession(tokenContext.getRealm(), token.getSessionId());
        LoginFormsProvider loginFormsProvider = (LoginFormsProvider)session.getProvider(LoginFormsProvider.class);
        if (rootAuthenticationSession != null && (authenticationFlowSession = rootAuthenticationSession.getAuthenticationSession(client, token.getTabId())) != null) {
            authenticationFlowSession.setAuthNote("SESSION_CONFIRMED", "true");
            Cookie cookie = CookieHelper.getCookie((Map)session.getContext().getRequestHeaders().getCookies(), (String)"AUTH_SESSION_ID");
            boolean sameBrowser = cookie != null && cookie.getValue().equals(token.getSessionId());
            MagicLinkContinuationBean magicLinkContinuationBean = new MagicLinkContinuationBean(sameBrowser, token.getRedirectUri());
            tokenContext.getEvent().success();
            return loginFormsProvider.setAttribute("magicLinkContinuation", (Object)magicLinkContinuationBean).createForm("email-confirmation.ftl");
        }
        tokenContext.getEvent().error("Expired magic link continuation session!");
        return loginFormsProvider.createForm("email-confirmation-error.ftl");
    }

    public AuthenticationSessionModel startFreshAuthenticationSession(MagicLinkContinuationActionToken token, ActionTokenContext<MagicLinkContinuationActionToken> tokenContext) {
        log.infof("startFreshAuthenticationSession %s", (Object)token.getIssuedFor());
        ClientModel client = tokenContext.getSession().clients().getClientByClientId(tokenContext.getRealm(), token.getIssuedFor());
        AuthenticationSessionProvider provider = tokenContext.getSession().authenticationSessions();
        RootAuthenticationSessionModel rootAuthenticationSession = provider.getRootAuthenticationSession(tokenContext.getRealm(), token.getSessionId());
        if (rootAuthenticationSession == null) {
            AuthenticationSessionModel authSession = tokenContext.createAuthenticationSessionForClient(token.getIssuedFor());
            authSession.setAuthNote("INVALIDATE_ACTION_TOKEN", "true");
            return authSession;
        }
        AuthenticationSessionModel authSession = rootAuthenticationSession.createAuthenticationSession(client);
        return authSession;
    }
}

