/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.magic.auth.MagicLinkContinuationAuthenticator;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class MagicLinkContinuationAuthenticatorFactory
implements AuthenticatorFactory {
    private static final Logger log = Logger.getLogger(MagicLinkContinuationAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "magic-link-continuation-form";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getDisplayType() {
        return "Magic Link continuation";
    }

    public String getHelpText() {
        return "Sign in with a magic link that will be sent to your email.";
    }

    public String getReferenceCategory() {
        return "alternate-auth";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty timeout = new ProviderConfigProperty();
        timeout.setType("String");
        timeout.setName("TIMEOUT");
        timeout.setLabel("Expiration time");
        timeout.setHelpText("Magic link authenticator expiration time in minutes. Default expiration period 10 minutes.");
        timeout.setDefaultValue((Object)"10");
        return List.of(timeout);
    }

    public Authenticator create(KeycloakSession session) {
        return new MagicLinkContinuationAuthenticator();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

