/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.resources;

import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.admin.AdminAuth;

public class CorsResource {
    private static final Logger log = Logger.getLogger(CorsResource.class);
    private final KeycloakSession session;
    private final HttpRequest request;
    public static final String[] METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"};

    public CorsResource(KeycloakSession session, HttpRequest request) {
        this.session = session;
        this.request = request;
    }

    @OPTIONS
    @Path(value="{any:.*}")
    public Response preflight() {
        log.debug((Object)"CORS OPTIONS preflight request");
        return Cors.add((HttpRequest)this.request, (Response.ResponseBuilder)Response.ok()).auth().allowedMethods(METHODS).preflight().build();
    }

    public static void setupCors(KeycloakSession session, AdminAuth auth) {
        HttpRequest request = session.getContext().getHttpRequest();
        HttpResponse response = session.getContext().getHttpResponse();
        Cors.add((HttpRequest)request).allowedOrigins(auth.getToken()).allowedMethods(METHODS).exposedHeaders(new String[]{"Location"}).auth().build(response);
    }
}

