/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.magic.auth.EmailOtpAuthenticator;
import java.util.List;
import lombok.Generated;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class EmailOtpAuthenticatorFactory
implements AuthenticatorFactory {
    @Generated
    private static final Logger log = Logger.getLogger(EmailOtpAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-email-otp";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};

    public Authenticator create(KeycloakSession session) {
        return new EmailOtpAuthenticator();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getReferenceCategory() {
        return "alternate-auth";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getDisplayType() {
        return "Email OTP";
    }

    public String getHelpText() {
        return "Sign in with a one-time-password that will be sent to your email.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty createUser = new ProviderConfigProperty();
        createUser.setType("boolean");
        createUser.setName("ext-magic-create-nonexistent-user");
        createUser.setLabel("Force create user");
        createUser.setHelpText("Creates a new user when an email is provided that does not match an existing user.");
        createUser.setDefaultValue((Object)false);
        return List.of(createUser);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

