/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud;

import java.net.MalformedURLException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.discovery.ProviderConfiguration;
import org.springframework.security.oauth2.client.discovery.ProviderDiscoveryClient;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.IssuerClaimVerifier;
import org.springframework.security.oauth2.provider.token.store.JwtClaimsSetVerifier;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

@Configuration
@ConditionalOnProperty(value={"sso.connector.cloud.available"})
public class IssuerCheckConfiguration {
    @Value(value="${ssoServiceUrl}")
    private String ssoServiceUrl;
    @Value(value="${security.oauth2.resource.jwk.key-set-uri}")
    private String keySetUri;

    @Bean
    public TokenStore jwkTokenStore() throws MalformedURLException {
        ProviderDiscoveryClient discoveryClient = new ProviderDiscoveryClient(this.ssoServiceUrl);
        ProviderConfiguration providerConfiguration = discoveryClient.discover();
        IssuerClaimVerifier issuerClaimVerifier = new IssuerClaimVerifier(providerConfiguration.getIssuer());
        return new JwkTokenStore(this.keySetUri, (JwtClaimsSetVerifier)issuerClaimVerifier);
    }
}

