/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud;

import io.pivotal.spring.cloud.SsoServiceInfo;
import java.util.HashMap;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class SsoServiceCredentialsListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private Cloud cloud;

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (this.cloud != null) {
            return;
        }
        try {
            this.cloud = new CloudFactory().getCloud();
        }
        catch (CloudException e) {
            return;
        }
        for (ServiceInfo serviceInfo : this.cloud.getServiceInfos()) {
            if (!(serviceInfo instanceof SsoServiceInfo)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            SsoServiceInfo ssoServiceInfo = (SsoServiceInfo)serviceInfo;
            map.put("security.oauth2.client.clientId", ssoServiceInfo.getClientId());
            map.put("security.oauth2.client.clientSecret", ssoServiceInfo.getClientSecret());
            map.put("security.oauth2.client.accessTokenUri", ssoServiceInfo.getAuthDomain() + "/oauth/token");
            map.put("security.oauth2.client.userAuthorizationUri", ssoServiceInfo.getAuthDomain() + "/oauth/authorize");
            map.put("ssoServiceUrl", ssoServiceInfo.getAuthDomain());
            map.put("security.oauth2.resource.userInfoUri", ssoServiceInfo.getAuthDomain() + "/userinfo");
            map.put("security.oauth2.resource.tokenInfoUri", ssoServiceInfo.getAuthDomain() + "/check_token");
            map.put("security.oauth2.resource.jwk.key-set-uri", ssoServiceInfo.getAuthDomain() + "/token_keys");
            MapPropertySource mapPropertySource = new MapPropertySource("vcapPivotalSso", map);
            event.getEnvironment().getPropertySources().addFirst((PropertySource)mapPropertySource);
        }
    }
}

