/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import reactor.core.publisher.MonoSink;

class CommittableBatch {
    private final Map<TopicPartition, Long> consumedOffsets = new HashMap<TopicPartition, Long>();
    private final Map<TopicPartition, Long> latestOffsets = new HashMap<TopicPartition, Long>();
    private int batchSize;
    private List<MonoSink<Void>> callbackEmitters = new ArrayList<MonoSink<Void>>();

    public synchronized int updateOffset(TopicPartition topicPartition, long offset) {
        if (this.consumedOffsets.put(topicPartition, offset) != Long.valueOf(offset)) {
            ++this.batchSize;
        }
        return this.batchSize;
    }

    public synchronized void addCallbackEmitter(MonoSink<Void> emitter) {
        this.callbackEmitters.add(emitter);
    }

    public synchronized boolean isEmpty() {
        return this.batchSize == 0;
    }

    public synchronized int batchSize() {
        return this.batchSize;
    }

    public synchronized CommitArgs getAndClearOffsets() {
        List<MonoSink<Void>> currentCallbackEmitters;
        HashMap<TopicPartition, OffsetAndMetadata> offsetMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.latestOffsets.putAll(this.consumedOffsets);
        Iterator<Map.Entry<TopicPartition, Long>> iterator = this.consumedOffsets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TopicPartition, Long> entry = iterator.next();
            offsetMap.put(entry.getKey(), new OffsetAndMetadata(entry.getValue() + 1L));
            iterator.remove();
        }
        this.batchSize = 0;
        if (!this.callbackEmitters.isEmpty()) {
            currentCallbackEmitters = this.callbackEmitters;
            this.callbackEmitters = new ArrayList<MonoSink<Void>>();
        } else {
            currentCallbackEmitters = null;
        }
        return new CommitArgs(offsetMap, currentCallbackEmitters);
    }

    public synchronized void restoreOffsets(CommitArgs commitArgs, boolean restoreCallbackEmitters) {
        for (Map.Entry entry : commitArgs.offsets.entrySet()) {
            TopicPartition topicPart = (TopicPartition)entry.getKey();
            long offset = ((OffsetAndMetadata)entry.getValue()).offset();
            Long latestOffset = this.latestOffsets.get(topicPart);
            if (latestOffset != null && latestOffset > offset - 1L) continue;
            this.consumedOffsets.putIfAbsent(topicPart, offset - 1L);
        }
        if (restoreCallbackEmitters && commitArgs.callbackEmitters != null) {
            this.callbackEmitters = commitArgs.callbackEmitters;
        }
    }

    public synchronized String toString() {
        return String.valueOf(this.consumedOffsets);
    }

    public static class CommitArgs {
        private Map<TopicPartition, OffsetAndMetadata> offsets;
        private List<MonoSink<Void>> callbackEmitters;

        CommitArgs(Map<TopicPartition, OffsetAndMetadata> offsets, List<MonoSink<Void>> callbackEmitters) {
            this.offsets = offsets;
            this.callbackEmitters = callbackEmitters;
        }

        public Map<TopicPartition, OffsetAndMetadata> offsets() {
            return this.offsets;
        }

        List<MonoSink<Void>> callbackEmitters() {
            return this.callbackEmitters;
        }
    }
}

