/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverPartition;

@Deprecated
class MutableReceiverOptions<K, V>
implements ReceiverOptions<K, V> {
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofMillis(100L);
    private static final int DEFAULT_MAX_COMMIT_ATTEMPTS = 100;
    private final Map<String, Object> properties;
    private final List<Consumer<Collection<ReceiverPartition>>> assignListeners;
    private final List<Consumer<Collection<ReceiverPartition>>> revokeListeners;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;
    private Duration pollTimeout;
    private Duration closeTimeout;
    private Duration commitInterval;
    private int commitBatchSize;
    private int atmostOnceCommitAheadSize;
    private int maxCommitAttempts;
    private Collection<String> subscribeTopics;
    private Collection<TopicPartition> assignTopicPartitions;
    private Pattern subscribePattern;
    private Supplier<Scheduler> schedulerSupplier;

    MutableReceiverOptions() {
        this(new HashMap<String, Object>());
    }

    MutableReceiverOptions(Properties properties) {
        this(properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)));
    }

    MutableReceiverOptions(Map<String, Object> configProperties) {
        this.properties = new HashMap<String, Object>(configProperties);
        this.assignListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>();
        this.revokeListeners = new ArrayList<Consumer<Collection<ReceiverPartition>>>();
        this.pollTimeout = DEFAULT_POLL_TIMEOUT;
        this.closeTimeout = Duration.ofNanos(Long.MAX_VALUE);
        this.commitInterval = Duration.ofMillis(5000L);
        this.commitBatchSize = 0;
        this.maxCommitAttempts = 100;
        this.properties.put("enable.auto.commit", "false");
        this.schedulerSupplier = Schedulers::parallel;
    }

    @Override
    public Map<String, Object> consumerProperties() {
        return this.properties;
    }

    @Override
    public Object consumerProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public ReceiverOptions<K, V> consumerProperty(String name, Object newValue) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(newValue);
        this.properties.put(name, newValue);
        return this;
    }

    @Override
    public ReceiverOptions<K, V> withKeyDeserializer(Deserializer<K> keyDeserializer) {
        this.keyDeserializer = Objects.requireNonNull(keyDeserializer);
        return this;
    }

    @Override
    public Deserializer<K> keyDeserializer() {
        return this.keyDeserializer;
    }

    @Override
    public ReceiverOptions<K, V> withValueDeserializer(Deserializer<V> valueDeserializer) {
        this.valueDeserializer = Objects.requireNonNull(valueDeserializer);
        return this;
    }

    @Override
    public Deserializer<V> valueDeserializer() {
        return this.valueDeserializer;
    }

    @Override
    public Duration pollTimeout() {
        return this.pollTimeout;
    }

    @Override
    public ReceiverOptions<K, V> pollTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Close timeout must be >= 0");
        }
        this.pollTimeout = Objects.requireNonNull(timeout);
        return this;
    }

    @Override
    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    @Override
    public ReceiverOptions<K, V> closeTimeout(Duration timeout) {
        if (timeout == null || timeout.isNegative()) {
            throw new IllegalArgumentException("Close timeout must be >= 0");
        }
        this.closeTimeout = Objects.requireNonNull(timeout);
        return this;
    }

    @Override
    public ReceiverOptions<K, V> addAssignListener(Consumer<Collection<ReceiverPartition>> onAssign) {
        this.assignListeners.add(Objects.requireNonNull(onAssign));
        return this;
    }

    @Override
    public ReceiverOptions<K, V> addRevokeListener(Consumer<Collection<ReceiverPartition>> onRevoke) {
        this.revokeListeners.add(Objects.requireNonNull(onRevoke));
        return this;
    }

    @Override
    public ReceiverOptions<K, V> clearAssignListeners() {
        this.assignListeners.clear();
        return this;
    }

    @Override
    public ReceiverOptions<K, V> clearRevokeListeners() {
        this.revokeListeners.clear();
        return this;
    }

    @Override
    public List<Consumer<Collection<ReceiverPartition>>> assignListeners() {
        return this.assignListeners;
    }

    @Override
    public List<Consumer<Collection<ReceiverPartition>>> revokeListeners() {
        return this.revokeListeners;
    }

    @Override
    public ReceiverOptions<K, V> subscription(Collection<String> topics) {
        this.subscribeTopics = Objects.requireNonNull(topics);
        this.subscribePattern = null;
        this.assignTopicPartitions = null;
        return this;
    }

    @Override
    public ReceiverOptions<K, V> subscription(Pattern pattern) {
        this.subscribeTopics = null;
        this.subscribePattern = Objects.requireNonNull(pattern);
        this.assignTopicPartitions = null;
        return this;
    }

    @Override
    public ReceiverOptions<K, V> assignment(Collection<TopicPartition> partitions) {
        this.subscribeTopics = null;
        this.subscribePattern = null;
        this.assignTopicPartitions = Objects.requireNonNull(partitions);
        return this;
    }

    @Override
    public Collection<TopicPartition> assignment() {
        return this.assignTopicPartitions;
    }

    @Override
    public Collection<String> subscriptionTopics() {
        return this.subscribeTopics;
    }

    @Override
    public Pattern subscriptionPattern() {
        return this.subscribePattern;
    }

    @Override
    public String groupId() {
        return (String)this.consumerProperty("group.id");
    }

    @Override
    public Duration heartbeatInterval() {
        long defaultValue = 3000L;
        long heartbeatIntervalMs = this.getLongOption("heartbeat.interval.ms", defaultValue);
        return Duration.ofMillis(heartbeatIntervalMs);
    }

    @Override
    public Duration commitInterval() {
        return this.commitInterval;
    }

    @Override
    public ReceiverOptions<K, V> commitInterval(Duration commitInterval) {
        if (commitInterval == null || commitInterval.isNegative()) {
            throw new IllegalArgumentException("Commit interval must be >= 0");
        }
        this.commitInterval = commitInterval;
        return this;
    }

    @Override
    public int commitBatchSize() {
        return this.commitBatchSize;
    }

    @Override
    public ReceiverOptions<K, V> commitBatchSize(int commitBatchSize) {
        if (commitBatchSize < 0) {
            throw new IllegalArgumentException("Commit batch size must be >= 0");
        }
        this.commitBatchSize = commitBatchSize;
        return this;
    }

    @Override
    public int atmostOnceCommitAheadSize() {
        return this.atmostOnceCommitAheadSize;
    }

    @Override
    public ReceiverOptions<K, V> atmostOnceCommitAheadSize(int commitAheadSize) {
        if (commitAheadSize < 0) {
            throw new IllegalArgumentException("Commit ahead size must be >= 0");
        }
        this.atmostOnceCommitAheadSize = commitAheadSize;
        return this;
    }

    @Override
    public int maxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    @Override
    public ReceiverOptions<K, V> maxCommitAttempts(int maxAttempts) {
        if (maxAttempts < 0) {
            throw new IllegalArgumentException("the number of attempts must be >= 0");
        }
        this.maxCommitAttempts = maxAttempts;
        return this;
    }

    @Override
    public Supplier<Scheduler> schedulerSupplier() {
        return this.schedulerSupplier;
    }

    @Override
    public ReceiverOptions<K, V> schedulerSupplier(Supplier<Scheduler> schedulerSupplier) {
        this.schedulerSupplier = Objects.requireNonNull(schedulerSupplier);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getLongOption(String optionName, long defaultValue) {
        Objects.requireNonNull(optionName);
        Object value = this.consumerProperty(optionName);
        long optionValue = 0L;
        if (value == null) return defaultValue;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (!(value instanceof String)) throw new ConfigException("Invalid value " + value);
        return Long.parseLong((String)value);
    }
}

