/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serializer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.kafka.sender.SenderOptions;
import reactor.kafka.sender.observation.KafkaSenderObservationConvention;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

class ImmutableSenderOptions<K, V>
implements SenderOptions<K, V> {
    private final Map<String, Object> properties;
    private final SenderOptions.ProducerListener producerListener;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final Duration closeTimeout;
    private final Scheduler scheduler;
    private final int maxInFlight;
    private final boolean stopOnError;
    private final ObservationRegistry observationRegistry;
    private final KafkaSenderObservationConvention observationConvention;

    ImmutableSenderOptions() {
        this(new HashMap<String, Object>());
    }

    ImmutableSenderOptions(Properties properties) {
        this(properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)));
    }

    ImmutableSenderOptions(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>(properties);
        this.keySerializer = null;
        this.valueSerializer = null;
        this.closeTimeout = Duration.ofMillis(Long.MAX_VALUE);
        this.scheduler = Schedulers.immediate();
        this.maxInFlight = Queues.SMALL_BUFFER_SIZE;
        this.stopOnError = true;
        this.producerListener = null;
        this.observationRegistry = ObservationRegistry.NOOP;
        this.observationConvention = null;
    }

    ImmutableSenderOptions(Map<String, Object> properties, Serializer<K> serializer, Serializer<V> valueSerializer, Duration timeout, Scheduler scheduler, int flight, boolean error, SenderOptions.ProducerListener producerListener, ObservationRegistry observationRegistry, KafkaSenderObservationConvention observationConvention) {
        this.properties = properties;
        this.keySerializer = serializer;
        this.valueSerializer = valueSerializer;
        this.closeTimeout = timeout;
        this.scheduler = scheduler;
        this.maxInFlight = flight;
        this.stopOnError = error;
        this.producerListener = producerListener;
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    @Override
    public Map<String, Object> producerProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public Object producerProperty(String name) {
        Objects.requireNonNull(name);
        return this.properties.get(name);
    }

    @Override
    public SenderOptions<K, V> producerProperty(String name, Object value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.properties);
        properties.put(name, value);
        return new ImmutableSenderOptions<K, V>(properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public Serializer<K> keySerializer() {
        return this.keySerializer;
    }

    @Override
    public SenderOptions<K, V> withKeySerializer(Serializer<K> keySerializer) {
        return new ImmutableSenderOptions<K, V>(this.properties, Objects.requireNonNull(keySerializer), this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public Serializer<V> valueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public SenderOptions<K, V> withValueSerializer(Serializer<V> valueSerializer) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, Objects.requireNonNull(valueSerializer), this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public SenderOptions<K, V> scheduler(Scheduler scheduler) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, Objects.requireNonNull(scheduler), this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public int maxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public SenderOptions<K, V> maxInFlight(int maxInFlight) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public boolean stopOnError() {
        return this.stopOnError;
    }

    @Override
    public SenderOptions<K, V> stopOnError(boolean stopOnError) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    @Override
    public SenderOptions<K, V> closeTimeout(Duration timeout) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, timeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public SenderOptions.ProducerListener producerListener() {
        return this.producerListener;
    }

    @Override
    public SenderOptions<K, V> producerListener(SenderOptions.ProducerListener producerListener) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, producerListener, this.observationRegistry, this.observationConvention);
    }

    @Override
    public SenderOptions<K, V> withObservation(@NonNull ObservationRegistry observationRegistry, @Nullable KafkaSenderObservationConvention observationConvention) {
        return new ImmutableSenderOptions<K, V>(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, observationRegistry, observationConvention);
    }

    @Override
    @NonNull
    public ObservationRegistry observationRegistry() {
        return this.observationRegistry;
    }

    @Override
    @Nullable
    public KafkaSenderObservationConvention observationConvention() {
        return this.observationConvention;
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.keySerializer, this.valueSerializer, this.closeTimeout, this.scheduler, this.maxInFlight, this.stopOnError, this.producerListener, this.observationRegistry, this.observationConvention);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass().equals(object.getClass())) {
            ImmutableSenderOptions that = (ImmutableSenderOptions)object;
            return Objects.equals(this.maxInFlight, that.maxInFlight) && Objects.equals(this.stopOnError, that.stopOnError) && Objects.equals(this.properties, that.properties) && Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.valueSerializer, that.valueSerializer) && Objects.equals(this.closeTimeout, that.closeTimeout) && Objects.equals(this.scheduler, that.scheduler) && Objects.equals(this.producerListener, that.producerListener) && Objects.equals(this.observationRegistry, that.observationRegistry) && Objects.equals(this.observationConvention, that.observationConvention);
        }
        return false;
    }
}

