/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.internals;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import reactor.kafka.receiver.internals.CommittableBatch;

class AtmostOnceOffsets {
    private final Map<TopicPartition, Long> committedOffsets = new ConcurrentHashMap<TopicPartition, Long>();
    private final Map<TopicPartition, Long> dispatchedOffsets = new ConcurrentHashMap<TopicPartition, Long>();

    AtmostOnceOffsets() {
    }

    void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            this.committedOffsets.put(entry.getKey(), entry.getValue().offset());
        }
    }

    void onDispatch(TopicPartition topicPartition, long offset) {
        this.dispatchedOffsets.put(topicPartition, offset);
    }

    long committedOffset(TopicPartition topicPartition) {
        Long offset = this.committedOffsets.get(topicPartition);
        return offset == null ? -1L : offset;
    }

    boolean undoCommitAhead(CommittableBatch committableBatch) {
        boolean undoRequired = false;
        for (Map.Entry<TopicPartition, Long> entry : this.committedOffsets.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            long offsetToCommit = this.dispatchedOffsets.get(entry.getKey()) + 1L;
            if (entry.getValue() <= offsetToCommit) continue;
            committableBatch.updateOffset(topicPartition, offsetToCommit);
            undoRequired = true;
        }
        return undoRequired;
    }
}

