/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import reactor.core.alloc.Recyclable;
import reactor.core.support.Assert;
import reactor.core.support.UUIDUtils;
import reactor.fn.Consumer;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;

public class Event<T>
implements Serializable,
Recyclable {
    private static final long serialVersionUID = -2476263092040373361L;
    private final transient Consumer<Throwable> errorConsumer;
    private volatile UUID id;
    private volatile Headers headers;
    private volatile Object replyTo;
    private volatile Object key;
    private volatile T data;

    public Event(Class<T> klass) {
        this.headers = null;
        this.data = null;
        this.errorConsumer = null;
    }

    public Event(Headers headers, T data) {
        this.headers = headers;
        this.data = data;
        this.errorConsumer = null;
    }

    public Event(Headers headers, T data, Consumer<Throwable> errorConsumer) {
        this.headers = headers;
        this.data = data;
        this.errorConsumer = errorConsumer;
    }

    public Event(T data) {
        this.data = data;
        this.errorConsumer = null;
    }

    public static <T> Event<T> wrap(T obj) {
        return new Event<T>(obj);
    }

    public static <T> Event<T> wrap(T obj, Object replyToKey) {
        return new Event<T>(obj).setReplyTo(replyToKey);
    }

    public synchronized UUID getId() {
        if (null == this.id) {
            this.id = UUIDUtils.create();
        }
        return this.id;
    }

    public synchronized Headers getHeaders() {
        if (null == this.headers) {
            this.headers = new Headers();
        }
        return this.headers;
    }

    public Object getReplyTo() {
        return this.replyTo;
    }

    public Event<T> setReplyTo(Object replyTo) {
        Assert.notNull(replyTo, "ReplyTo cannot be null.");
        this.replyTo = replyTo;
        return this;
    }

    public Object getKey() {
        return this.key;
    }

    public Event<T> setKey(Object key) {
        this.key = key;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public Event<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Consumer<Throwable> getErrorConsumer() {
        return this.errorConsumer;
    }

    public Event<T> copy() {
        return this.copy(this.data);
    }

    public <E> Event<E> copy(E data) {
        if (null != this.replyTo) {
            return new Event<E>(this.headers, data, this.errorConsumer).setReplyTo(this.replyTo);
        }
        return new Event<E>(this.headers, data, this.errorConsumer);
    }

    public void consumeError(Throwable throwable) {
        if (null != this.errorConsumer) {
            this.errorConsumer.accept(throwable);
        }
    }

    @Override
    public void recycle() {
        this.id = null;
        if (null != this.headers) {
            this.headers.headers.clear();
        }
        this.replyTo = null;
        this.key = null;
        this.data = null;
    }

    public void override(Event<T> ev) {
        this.id = ev.id;
        this.headers = ev.headers;
        this.replyTo = ev.replyTo;
        this.data = ev.data;
    }

    public String toString() {
        return "Event{id=" + this.id + ", headers=" + this.headers + ", replyTo=" + this.replyTo + ", key=" + this.key + ", data=" + this.data + '}';
    }

    public static class Headers
    implements Serializable,
    Iterable<Tuple2<String, Object>> {
        public static final String ORIGIN = "x-reactor-origin";
        private static final long serialVersionUID = 4984692586458514948L;
        private final Object monitor = UUIDUtils.create();
        private final Map<String, Object> headers;

        private Headers(boolean sealed, Map<String, Object> headers) {
            TreeMap<String, Object> copy = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.copyHeaders(headers, copy);
            this.headers = sealed ? Collections.unmodifiableMap(copy) : copy;
        }

        public Headers(Map<String, Object> headers) {
            this(false, headers);
        }

        public Headers() {
            this(false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers setAll(Map<String, Object> headers) {
            if (null == headers || headers.isEmpty()) {
                return this;
            }
            Object object = this.monitor;
            synchronized (object) {
                this.copyHeaders(headers, this.headers);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> Headers set(String name, V value) {
            Object object = this.monitor;
            synchronized (object) {
                this.setHeader(name, value, this.headers);
            }
            return this;
        }

        public Headers setOrigin(UUID id) {
            String idString = id == null ? null : id.toString();
            return this.setOrigin(idString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOrigin() {
            Object object = this.monitor;
            synchronized (object) {
                return (String)this.headers.get(ORIGIN);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers setOrigin(String id) {
            Object object = this.monitor;
            synchronized (object) {
                this.setHeader(ORIGIN, id, this.headers);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> V get(String name) {
            Object object = this.monitor;
            synchronized (object) {
                return (V)this.headers.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String name) {
            Object object = this.monitor;
            synchronized (object) {
                return this.headers.containsKey(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> asMap() {
            Object object = this.monitor;
            synchronized (object) {
                return Collections.unmodifiableMap(this.headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Headers readOnly() {
            Object object = this.monitor;
            synchronized (object) {
                return new Headers(true, this.headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Tuple2<String, Object>> iterator() {
            Object object = this.monitor;
            synchronized (object) {
                ArrayList<Tuple2<String, Object>> headers = new ArrayList<Tuple2<String, Object>>(this.headers.size());
                for (Map.Entry<String, Object> header : this.headers.entrySet()) {
                    headers.add(Tuple.of(header.getKey(), header.getValue()));
                }
                return Collections.unmodifiableList(headers).iterator();
            }
        }

        public String toString() {
            return this.headers.toString();
        }

        private void copyHeaders(Map<String, Object> source, Map<String, Object> target) {
            if (source != null) {
                for (Map.Entry<String, Object> entry : source.entrySet()) {
                    this.setHeader(entry.getKey(), entry.getValue(), target);
                }
            }
        }

        private void setHeader(String name, Object value, Map<String, Object> target) {
            if (value == null) {
                target.remove(name);
            } else {
                target.put(name, value);
            }
        }
    }
}

