/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.convert;

public class ConversionFailedException
extends IllegalStateException {
    private static final long serialVersionUID = -8502594056926933555L;
    private final Class<?> sourceType;
    private final Class<?> targetType;

    ConversionFailedException(Class<?> sourceType, Class<?> targetType) {
        super(String.format("Cannot convert %s to type %s", sourceType.getName(), targetType.getName()));
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    ConversionFailedException(Throwable cause, Class<?> sourceType, Class<?> targetType) {
        super(String.format("Cannot convert %s to type %s", sourceType.getName(), targetType.getName()), cause);
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }
}

