/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import reactor.bus.convert.ConversionFailedException;
import reactor.bus.convert.Converter;

public class DelegatingConverter
implements Converter {
    private final List<Converter> delegateConverters;

    public DelegatingConverter(List<Converter> delegateConverters) {
        this.delegateConverters = new ArrayList<Converter>(delegateConverters);
    }

    public DelegatingConverter(Converter ... delegateConverters) {
        this.delegateConverters = Arrays.asList(delegateConverters);
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (this.delegateConverters != null && !this.delegateConverters.isEmpty()) {
            for (Converter c : this.delegateConverters) {
                if (!c.canConvert(sourceType, targetType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        if (null == source) {
            return null;
        }
        for (Converter c : this.delegateConverters) {
            if (!c.canConvert(source.getClass(), targetType)) continue;
            return c.convert(source, targetType);
        }
        throw new ConversionFailedException(source.getClass(), targetType);
    }
}

