/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.convert;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import reactor.bus.convert.ConversionFailedException;
import reactor.bus.convert.Converter;
import reactor.bus.convert.DelegatingConverter;
import reactor.core.support.Assert;

public abstract class StandardConverters {
    private static final Map<Class<?>, Constructor<?>> CTORS = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, Class<?>> CTOR_PARAMS = Collections.synchronizedMap(new HashMap());
    public static final Converter CONVERTERS = new DelegatingConverter(StringToNumberConverter.INSTANCE, ConstructorParameterConverter.INSTANCE, ToStringConverter.INSTANCE);

    protected StandardConverters() {
    }

    private static Class<?> findFirstCtorParam(Class<?> type) {
        Class<?> paramType = CTOR_PARAMS.get(type);
        if (null != paramType) {
            return paramType;
        }
        for (Constructor<?> ctor : type.getConstructors()) {
            if (ctor.getParameterTypes().length != 1) continue;
            paramType = ctor.getParameterTypes()[0];
            CTOR_PARAMS.put(type, paramType);
            CTORS.put(type, ctor);
            return paramType;
        }
        return null;
    }

    public static enum ToStringConverter implements Converter
    {
        INSTANCE;


        @Override
        public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
            return String.class == targetType;
        }

        @Override
        public <T> T convert(Object source, Class<T> targetType) {
            return (T)String.format("%s", source);
        }
    }

    public static enum StringToNumberConverter implements Converter
    {
        INSTANCE;


        @Override
        public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
            return String.class == sourceType && Number.class.isAssignableFrom(targetType);
        }

        @Override
        public <T> T convert(Object source, Class<T> targetType) {
            Assert.notNull(source, "Source cannot be null when converting to a Number.");
            if (Integer.class == targetType) {
                return (T)Integer.valueOf(source.toString());
            }
            if (Byte.class == targetType) {
                return (T)Byte.valueOf(source.toString());
            }
            if (Long.class == targetType) {
                return (T)Long.valueOf(source.toString());
            }
            if (Short.class == targetType) {
                return (T)Short.valueOf(source.toString());
            }
            if (Float.class == targetType) {
                return (T)Float.valueOf(source.toString());
            }
            if (Double.class == targetType) {
                return (T)Double.valueOf(source.toString());
            }
            if (BigInteger.class == targetType) {
                return (T)BigInteger.valueOf(Long.valueOf(source.toString()));
            }
            if (AtomicInteger.class == targetType) {
                return (T)new AtomicInteger(Integer.valueOf(source.toString()));
            }
            if (AtomicLong.class == targetType) {
                return (T)new AtomicLong(Long.valueOf(source.toString()));
            }
            throw new ConversionFailedException(source.getClass(), targetType);
        }
    }

    public static enum ConstructorParameterConverter implements Converter
    {
        INSTANCE;


        @Override
        public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
            Class paramType = StandardConverters.findFirstCtorParam(targetType);
            return null != paramType && (paramType.isAssignableFrom(sourceType) || CONVERTERS.canConvert(sourceType, paramType));
        }

        @Override
        public <T> T convert(Object source, Class<T> targetType) {
            Assert.notNull(source, "Source object cannot be null.");
            Class paramType = StandardConverters.findFirstCtorParam(targetType);
            if (!paramType.isAssignableFrom(source.getClass())) {
                source = CONVERTERS.convert(source, paramType);
            }
            try {
                return ((Constructor)CTORS.get(targetType)).newInstance(source);
            }
            catch (Throwable t) {
                throw new ConversionFailedException(t, source.getClass(), targetType);
            }
        }
    }
}

