/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import reactor.bus.filter.AbstractFilter;
import reactor.core.support.Assert;

public final class RoundRobinFilter
extends AbstractFilter {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Map<Object, AtomicLong> usageCounts = new HashMap<Object, AtomicLong>();

    @Override
    public <T> List<T> doFilter(List<T> items, Object key) {
        Assert.notNull(key, "'key' must not be null");
        if (items.isEmpty()) {
            return items;
        }
        int index = (int)(this.getUsageCount(key).getAndIncrement() % (long)items.size());
        return Collections.singletonList(items.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicLong getUsageCount(Object key) {
        this.readLock.lock();
        try {
            AtomicLong usageCount = this.usageCounts.get(key);
            if (usageCount == null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    usageCount = this.usageCounts.get(key);
                    if (usageCount == null) {
                        usageCount = new AtomicLong();
                        this.usageCounts.put(key, usageCount);
                    }
                }
                finally {
                    this.writeLock.unlock();
                    this.readLock.lock();
                }
            }
            AtomicLong atomicLong = usageCount;
            return atomicLong;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

