/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.registry;

import reactor.bus.registry.Registration;
import reactor.bus.selector.ObjectSelector;
import reactor.bus.selector.Selector;
import reactor.fn.Pausable;

public class CachableRegistration<T>
implements Registration<T> {
    private static final Selector NO_MATCH = new ObjectSelector<Void>(null){

        @Override
        public boolean matches(Object key) {
            return false;
        }
    };
    private final Selector selector;
    private final T object;
    private final Runnable onCancel;
    private final boolean lifecycle;
    private volatile boolean cancelled = false;
    private volatile boolean cancelAfterUse = false;
    private volatile boolean paused = false;

    public CachableRegistration(Selector selector, T object, Runnable onCancel) {
        this.selector = selector;
        this.object = object;
        this.onCancel = onCancel;
        this.lifecycle = Pausable.class.isAssignableFrom(object.getClass());
    }

    @Override
    public Selector getSelector() {
        return !this.cancelled ? this.selector : NO_MATCH;
    }

    @Override
    public T getObject() {
        return !this.cancelled && !this.paused ? (T)this.object : null;
    }

    @Override
    public Registration<T> cancelAfterUse() {
        this.cancelAfterUse = true;
        return this;
    }

    @Override
    public boolean isCancelAfterUse() {
        return this.cancelAfterUse;
    }

    @Override
    public Registration<T> cancel() {
        if (!this.cancelled) {
            if (null != this.onCancel) {
                this.onCancel.run();
            }
            if (this.lifecycle) {
                ((Pausable)this.object).cancel();
            }
            this.cancelled = true;
        }
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public Registration<T> pause() {
        this.paused = true;
        if (this.lifecycle) {
            ((Pausable)this.object).pause();
        }
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public Registration<T> resume() {
        this.paused = false;
        if (this.lifecycle) {
            ((Pausable)this.object).resume();
        }
        return this;
    }

    public String toString() {
        return "CachableRegistration{\n\tselector=" + this.selector + ",\n\tobject=" + this.object + ",\n\tonCancel=" + this.onCancel + ",\n\tlifecycle=" + this.lifecycle + ",\n\tcancelled=" + this.cancelled + ",\n\tcancelAfterUse=" + this.cancelAfterUse + ",\n\tpaused=" + this.paused + "\n}";
    }
}

