/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import reactor.bus.registry.CachableRegistration;
import reactor.bus.registry.Registration;
import reactor.bus.registry.Registry;
import reactor.bus.selector.Selector;
import reactor.fn.Consumer;
import reactor.jarjar.jsr166e.ConcurrentHashMapV8;

public class SimpleCachingRegistry<T>
implements Registry<T> {
    private final ConcurrentHashMapV8<Object, List<Registration<? extends T>>> cache = new ConcurrentHashMapV8();
    private final ConcurrentHashMapV8<Selector, List<Registration<? extends T>>> registrations = new ConcurrentHashMapV8();
    private final boolean useCache;
    private final boolean cacheNotFound;
    private final Consumer<Object> onNotFound;

    SimpleCachingRegistry(boolean useCache, boolean cacheNotFound, Consumer<Object> onNotFound) {
        this.useCache = useCache;
        this.cacheNotFound = cacheNotFound;
        this.onNotFound = onNotFound;
    }

    @Override
    public synchronized Registration<T> register(final Selector sel, T obj) {
        List<Registration<T>> regs = this.registrations.get(sel);
        if (null == regs) {
            regs = this.registrations.computeIfAbsent(sel, new ConcurrentHashMapV8.Fun<Selector, List<Registration<? extends T>>>(){

                @Override
                public List<Registration<? extends T>> apply(Selector selector) {
                    return new ArrayList();
                }
            });
        }
        CachableRegistration<T> reg = new CachableRegistration<T>(sel, obj, new Runnable(){

            @Override
            public void run() {
                SimpleCachingRegistry.this.registrations.remove(sel);
                SimpleCachingRegistry.this.cache.clear();
            }
        });
        regs.add(reg);
        return reg;
    }

    @Override
    public synchronized boolean unregister(Object key) {
        boolean found = false;
        for (Selector sel : this.registrations.keySet()) {
            if (!sel.matches(key) || null == this.registrations.remove(sel) || found) continue;
            found = true;
        }
        if (this.useCache) {
            this.cache.remove(key);
        }
        return found;
    }

    @Override
    public synchronized List<Registration<? extends T>> select(final Object key) {
        List<Registration<? extends T>> selectedRegs = this.cache.get(key);
        if (null != selectedRegs) {
            return selectedRegs;
        }
        final ArrayList<Registration<T>> regs = new ArrayList<Registration<T>>();
        this.registrations.forEach(new ConcurrentHashMapV8.BiAction<Selector, List<Registration<? extends T>>>(){

            @Override
            public void apply(Selector selector, List<Registration<? extends T>> registrations) {
                if (selector.matches(key)) {
                    regs.addAll(registrations);
                }
            }
        });
        if (regs.isEmpty() && null != this.onNotFound) {
            this.onNotFound.accept(key);
        }
        if (this.useCache && (!regs.isEmpty() || this.cacheNotFound)) {
            this.cache.put(key, regs);
        }
        return regs;
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
        this.registrations.clear();
    }

    @Override
    public synchronized Iterator<Registration<? extends T>> iterator() {
        final ArrayList regs = new ArrayList();
        this.registrations.forEach(new ConcurrentHashMapV8.BiAction<Selector, List<Registration<? extends T>>>(){

            @Override
            public void apply(Selector selector, List<Registration<? extends T>> registrations) {
                regs.addAll(registrations);
            }
        });
        return regs.iterator();
    }
}

