/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.selector;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.ObjectSelector;

public class UriSelector
extends ObjectSelector<URI> {
    private static final UriHeaderResolver URI_HEADER_RESOLVER = new UriHeaderResolver();
    private final String scheme;
    private final String host;
    private final int port;
    private final String path;
    private final String fragment;

    public UriSelector(String uri) {
        this(URI.create(uri));
    }

    public UriSelector(URI uri) {
        super(uri);
        int i;
        this.scheme = null != uri.getScheme() ? uri.getScheme() : "*";
        String authority = uri.getAuthority();
        String string = this.host = null != uri.getHost() ? uri.getHost() : "*";
        this.port = authority.contains("*:") ? ((i = authority.lastIndexOf(":") + 1) > 1 ? Integer.parseInt(authority.substring(i)) : -1) : uri.getPort();
        this.path = null != uri.getPath() ? uri.getPath() : "/*";
        this.fragment = uri.getFragment();
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return URI_HEADER_RESOLVER;
    }

    @Override
    public boolean matches(Object key) {
        if (null == key) {
            return false;
        }
        URI uri = UriSelector.objectToURI(key);
        if (uri == null) {
            return false;
        }
        boolean schemeMatches = "*".equals(this.scheme) || this.scheme.equals(uri.getScheme());
        boolean hostMatches = "*".equals(this.host) || this.host.equals(uri.getHost());
        boolean portMatches = -1 == this.port || this.port == uri.getPort();
        boolean pathMatches = "/*".equals(this.path) || this.path.equals(uri.getPath());
        boolean fragmentMatches = null == this.fragment || this.fragment.equals(uri.getFragment());
        return schemeMatches && hostMatches && portMatches && pathMatches && fragmentMatches;
    }

    private static URI objectToURI(Object key) {
        if (key instanceof URI) {
            return (URI)key;
        }
        if (key instanceof String) {
            return URI.create(key.toString());
        }
        return null;
    }

    private static class UriHeaderResolver
    implements HeaderResolver {
        private UriHeaderResolver() {
        }

        @Nullable
        public Map<String, Object> resolve(Object key) {
            if (null == key) {
                return null;
            }
            URI uri = UriSelector.objectToURI(key);
            if (uri == null) {
                return null;
            }
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("authority", uri.getAuthority());
            headers.put("fragment", uri.getFragment());
            headers.put("host", uri.getHost());
            headers.put("path", uri.getPath());
            headers.put("port", String.valueOf(uri.getPort()));
            headers.put("query", uri.getQuery());
            if (null != uri.getQuery()) {
                try {
                    String query = URLDecoder.decode(uri.getQuery(), "ISO-8859-1");
                    for (String s : query.split("&")) {
                        String[] parts = s.split("=");
                        headers.put(parts[0], parts[1]);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            headers.put("scheme", uri.getScheme());
            headers.put("userInfo", uri.getUserInfo());
            return headers;
        }
    }
}

