/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.spec;

import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.fn.Supplier;

public abstract class DispatcherComponentSpec<SPEC extends DispatcherComponentSpec<SPEC, TARGET>, TARGET>
implements Supplier<TARGET> {
    private Environment env;
    private Dispatcher dispatcher;

    public final SPEC env(Environment env) {
        this.env = env;
        return (SPEC)this;
    }

    public final SPEC defaultDispatcher() {
        this.assertNonNullEnvironment("Cannot use the default Dispatcher without an Environment");
        this.dispatcher = this.env.getDefaultDispatcher();
        return (SPEC)this;
    }

    public final SPEC synchronousDispatcher() {
        this.dispatcher = SynchronousDispatcher.INSTANCE;
        return (SPEC)this;
    }

    public final SPEC dispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return (SPEC)this;
    }

    public final SPEC dispatcher(String dispatcherName) {
        this.assertNonNullEnvironment("Cannot reference a Dispatcher by name without an Environment");
        this.dispatcher = this.env.getDispatcher(dispatcherName);
        return (SPEC)this;
    }

    @Override
    public final TARGET get() {
        return this.configure(this.getDispatcher(), this.env);
    }

    private Dispatcher getDispatcher() {
        if (this.dispatcher != null) {
            return this.dispatcher;
        }
        if (this.env != null) {
            return this.env.getDefaultDispatcher();
        }
        return SynchronousDispatcher.INSTANCE;
    }

    private void assertNonNullEnvironment(String message) {
        if (this.env == null) {
            throw new IllegalStateException(message);
        }
    }

    protected abstract TARGET configure(Dispatcher var1, Environment var2);
}

