/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.support;

import reactor.bus.Event;
import reactor.bus.EventBus;
import reactor.bus.Observable;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public class NotifyConsumer<T>
implements Consumer<T> {
    private final Object notifyKey;
    private final Observable observable;
    private final boolean wrapEvent;

    public NotifyConsumer(Object notifyKey, Observable<?> observable) {
        Assert.notNull(observable, "Observable cannot be null.");
        this.notifyKey = notifyKey;
        this.observable = observable;
        this.wrapEvent = EventBus.class.isAssignableFrom(observable.getClass());
    }

    @Override
    public void accept(T t) {
        this.observable.notify(this.notifyKey, this.wrapEvent ? Event.wrap(t) : t);
    }
}

