/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc;

import java.util.List;
import reactor.core.alloc.AbstractReference;
import reactor.core.alloc.Allocator;
import reactor.core.alloc.Recyclable;
import reactor.core.alloc.Reference;
import reactor.fn.Supplier;
import reactor.jarjar.jsr166e.ConcurrentHashMapV8;

public abstract class PartitionedAllocator<T extends Recyclable>
implements Allocator<T> {
    private final ConcurrentHashMapV8<Long, Reference<T>> partitions = new ConcurrentHashMapV8();
    private final ConcurrentHashMapV8.Fun<Long, Reference<T>> newRefFn = new ConcurrentHashMapV8.Fun<Long, Reference<T>>(){

        @Override
        public Reference<T> apply(Long partId) {
            return new PartitionedReference<Recyclable>((Recyclable)PartitionedAllocator.this.factory.get(), partId);
        }
    };
    private final Supplier<T> factory;

    protected PartitionedAllocator(Supplier<T> factory) {
        this.factory = factory;
    }

    @Override
    public Reference<T> allocate() {
        long partId = this.nextPartitionId();
        Reference<T> ref = this.partitions.get(partId);
        if (null != ref || null != (ref = this.partitions.computeIfAbsent((Long)partId, this.newRefFn))) {
            return ref;
        }
        throw new IllegalStateException("Could not allocate from " + this.factory + " for thread " + Thread.currentThread());
    }

    @Override
    public List<Reference<T>> allocateBatch(int size) {
        throw new IllegalStateException("PartitionedAllocators don't allocate via batch");
    }

    @Override
    public void release(List<Reference<T>> batch) {
        for (Reference<T> ref : batch) {
            if (!(ref instanceof PartitionedReference)) continue;
            long partId = ((PartitionedReference)ref).getPartitionId();
            this.partitions.get(partId).release();
        }
    }

    protected abstract long nextPartitionId();

    private static class PartitionedReference<T extends Recyclable>
    extends AbstractReference<T> {
        private final long partitionId;

        public PartitionedReference(T obj, long partitionId) {
            super(obj);
            this.partitionId = partitionId;
        }

        public long getPartitionId() {
            return this.partitionId;
        }
    }
}

