/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import reactor.core.alloc.AbstractReference;
import reactor.core.alloc.Allocator;
import reactor.core.alloc.Recyclable;
import reactor.core.alloc.Reference;
import reactor.fn.Supplier;

public class ReferenceCountingAllocator<T extends Recyclable>
implements Allocator<T> {
    private static final int DEFAULT_INITIAL_SIZE = 2048;
    private final ReentrantLock refLock = new ReentrantLock();
    private final ReentrantLock leaseLock = new ReentrantLock();
    private final ArrayList<Reference<T>> references = new ArrayList();
    private final Supplier<T> factory;
    private volatile BitSet leaseMask;

    public ReferenceCountingAllocator(Supplier<T> factory) {
        this(2048, factory);
    }

    public ReferenceCountingAllocator(int initialSize, Supplier<T> factory) {
        this.factory = factory;
        this.references.ensureCapacity(initialSize);
        this.leaseMask = new BitSet(initialSize);
        this.expand(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference<T> allocate() {
        int next;
        int len = this.refCnt();
        this.leaseLock.lock();
        try {
            next = this.leaseMask.nextClearBit(0);
            if (next >= len) {
                this.expand(len);
            }
            this.leaseMask.set(next);
        }
        finally {
            this.leaseLock.unlock();
        }
        if (next < 0) {
            throw new RuntimeException("Allocator is exhausted.");
        }
        Reference<T> ref = this.references.get(next);
        if (null == ref) {
            this.refLock.lock();
            try {
                ref = new ReferenceCountingAllocatorReference(this, (Recyclable)this.factory.get(), next);
                this.references.set(next, ref);
            }
            finally {
                this.refLock.unlock();
            }
        }
        ref.retain();
        return ref;
    }

    @Override
    public List<Reference<T>> allocateBatch(int size) {
        ArrayList<Reference<T>> refs = new ArrayList<Reference<T>>(size);
        for (int i = 0; i < size; ++i) {
            refs.add(this.allocate());
        }
        return refs;
    }

    @Override
    public void release(List<Reference<T>> batch) {
        if (null != batch && !batch.isEmpty()) {
            for (Reference<T> ref : batch) {
                ref.release();
            }
        }
    }

    private int refCnt() {
        this.refLock.lock();
        try {
            int n = this.references.size();
            return n;
        }
        finally {
            this.refLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(int num) {
        this.refLock.lock();
        try {
            int len = this.references.size();
            int newLen = len + num;
            for (int i = len; i <= newLen; ++i) {
                this.references.add(new ReferenceCountingAllocatorReference(this, (Recyclable)this.factory.get(), i));
            }
            BitSet newLeaseMask = new BitSet(newLen);
            int leases = this.leaseMask.length();
            for (int i = 0; i < leases; ++i) {
                newLeaseMask.set(i, this.leaseMask.get(i));
            }
            this.leaseMask = newLeaseMask;
        }
        finally {
            this.refLock.unlock();
        }
    }

    private class ReferenceCountingAllocatorReference<T extends Recyclable>
    extends AbstractReference<T> {
        private final int bit;
        final /* synthetic */ ReferenceCountingAllocator this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private ReferenceCountingAllocatorReference(T obj, int bit) {
            this.this$0 = (ReferenceCountingAllocator)n;
            super(obj);
            this.bit = bit;
        }

        @Override
        public void release(int decr) {
            this.this$0.leaseLock.lock();
            try {
                super.release(decr);
                if (this.getReferenceCount() < 1) {
                    this.this$0.leaseMask.clear(this.bit);
                }
            }
            finally {
                this.this$0.leaseLock.unlock();
            }
        }
    }
}

