/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.alloc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import reactor.core.alloc.AbstractReference;
import reactor.core.alloc.Allocator;
import reactor.core.alloc.Recyclable;
import reactor.core.alloc.Reference;
import reactor.core.support.Identifiable;
import reactor.core.support.NamedDaemonThreadFactory;
import reactor.fn.Supplier;
import reactor.jarjar.com.lmax.disruptor.BlockingWaitStrategy;
import reactor.jarjar.com.lmax.disruptor.EventFactory;
import reactor.jarjar.com.lmax.disruptor.EventHandler;
import reactor.jarjar.com.lmax.disruptor.ExceptionHandler;
import reactor.jarjar.com.lmax.disruptor.RingBuffer;
import reactor.jarjar.com.lmax.disruptor.WaitStrategy;
import reactor.jarjar.com.lmax.disruptor.WorkHandler;
import reactor.jarjar.com.lmax.disruptor.dsl.Disruptor;
import reactor.jarjar.com.lmax.disruptor.dsl.ProducerType;

public class RingBufferAllocator<T extends Recyclable>
implements Allocator<T> {
    private final ExecutorService executor;
    private final boolean shutdownExecutor;
    private final Disruptor<Reference<T>> disruptor;
    private RingBuffer<Reference<T>> ringBuffer;

    public RingBufferAllocator(String name, int poolSize, Supplier<T> poolFactory) {
        this(name, poolSize, poolFactory, 1);
    }

    public RingBufferAllocator(String name, int poolSize, Supplier<T> poolFactory, int eventThreads) {
        this(name, poolSize, poolFactory, eventThreads, null, null, ProducerType.MULTI, new BlockingWaitStrategy(), null);
    }

    public RingBufferAllocator(String name, int poolSize, final Supplier<T> poolFactory, int eventThreads, final EventHandler<Reference<T>> eventHandler, ExceptionHandler errorHandler, ProducerType producerType, WaitStrategy waitStrategy, ExecutorService executor) {
        if (null == executor) {
            this.executor = Executors.newFixedThreadPool(eventThreads, new NamedDaemonThreadFactory(name));
            this.shutdownExecutor = true;
        } else {
            this.executor = executor;
            this.shutdownExecutor = false;
        }
        this.disruptor = new Disruptor(new EventFactory<Reference<T>>(){

            @Override
            public Reference<T> newInstance() {
                return new RingBufferReference(RingBufferAllocator.this, (Recyclable)poolFactory.get());
            }
        }, poolSize, this.executor, producerType, waitStrategy);
        if (null != errorHandler) {
            this.disruptor.handleExceptionsWith(errorHandler);
        }
        if (null != eventHandler) {
            if (eventThreads > 1) {
                WorkHandler[] workHandlers = new WorkHandler[eventThreads];
                for (int i = 0; i < eventThreads; ++i) {
                    workHandlers[i] = new WorkHandler<Reference<T>>(){

                        @Override
                        public void onEvent(Reference<T> ref) throws Exception {
                            eventHandler.onEvent(ref, -1L, false);
                        }
                    };
                }
                this.disruptor.handleEventsWithWorkerPool(workHandlers);
            } else {
                this.disruptor.handleEventsWith(eventHandler);
            }
        }
    }

    @Override
    public Reference<T> allocate() {
        long l = this.ringBuffer.next();
        RingBufferReference ref = (RingBufferReference)this.ringBuffer.get(l);
        ref.setSequenceId(l);
        ref.retain();
        return ref;
    }

    public List<Reference<T>> allocateBatch(int size, List<Reference<T>> refs) {
        for (int i = 0; i < size; ++i) {
            Reference<T> ref = this.allocate();
            refs.add(ref);
        }
        return refs;
    }

    @Override
    public List<Reference<T>> allocateBatch(int size) {
        return this.allocateBatch(size, new ArrayList<Reference<T>>(size));
    }

    @Override
    public void release(List<Reference<T>> batch) {
        if (null == batch || batch.isEmpty()) {
            return;
        }
        long start = ((RingBufferReference)batch.get(0)).sequenceId;
        int len = batch.size();
        if (len > 1) {
            long end = ((RingBufferReference)batch.get(len - 1)).sequenceId;
            this.ringBuffer.publish(start, end);
        } else if (!this.ringBuffer.isPublished(start)) {
            this.ringBuffer.publish(start);
        }
        batch.clear();
    }

    public boolean alive() {
        return !this.executor.isShutdown();
    }

    public void start() {
        this.ringBuffer = this.disruptor.start();
    }

    public boolean awaitAndShutdown() {
        return this.awaitAndShutdown(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        try {
            if (this.shutdownExecutor) {
                boolean bl = this.executor.awaitTermination(timeout, timeUnit);
                return bl;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.shutdown();
        }
        return true;
    }

    public void shutdown() {
        this.disruptor.shutdown();
        if (this.shutdownExecutor) {
            this.executor.shutdown();
        }
    }

    public void halt() {
        if (this.shutdownExecutor) {
            this.executor.shutdownNow();
        }
        this.disruptor.halt();
    }

    private static class RingBufferReference
    extends AbstractReference<T> {
        private final boolean isIdentifiable;
        private volatile long sequenceId;
        final /* synthetic */ RingBufferAllocator this$0;

        private RingBufferReference(T obj) {
            this.this$0 = var1_1;
            super(obj);
            this.isIdentifiable = Identifiable.class.isInstance(obj);
        }

        public void setSequenceId(long sequenceId) {
            this.sequenceId = sequenceId;
            if (this.isIdentifiable) {
                ((Identifiable)this.get()).setId(sequenceId);
            }
        }

        @Override
        public void release(int decr) {
            if (!this.this$0.ringBuffer.isPublished(this.sequenceId)) {
                this.this$0.ringBuffer.publish(this.sequenceId);
                if (1 == decr) {
                    return;
                }
            }
            super.release(decr);
        }
    }
}

